-- $Horde: 

CREATE TABLE moment_meetings (
    meeting_organizer   VARCHAR(255) NOT NULL,
    meeting_id          INT NOT NULL,
    meeting_title       VARCHAR(64) NOT NULL,
    meeting_description TEXT,
    meeting_location    VARCHAR(64) NULL,
    meeting_start       INT NOT NULL,
    meeting_end         INT NOT NULL,
    meeting_attendees   TEXT NOT NULL,
    meeting_uid         VARCHAR(255) NOT NULL,
    meeting_sequence    INT NOT NULL DEFAULT 0,
    meeting_status      VARCHAR(20) NULL,

    PRIMARY KEY         (meeting_organizer, meeting_id)
);

CREATE INDEX moment_meeting_idx ON moment_meetings (meeting_uid);

CREATE TABLE moment_storage (
    vfb_owner      VARCHAR(255) DEFAULT NULL,
    vfb_email      VARCHAR(255) NOT NULL DEFAULT '',
    vfb_serialized TEXT NOT NULL
);

CREATE INDEX moment_vfb_owner_idx ON moment_storage (vfb_owner);
CREATE INDEX moment_vfb_email_idx ON moment_storage (vfb_email);

GRANT SELECT, INSERT, UPDATE, DELETE ON moment_meetings To horde;
GRANT SELECT, INSERT, UPDATE, DELETE ON moment_storage TO horde;
