<?php

require_once HORDE_BASE . '/lib/MIME/Viewer/images.php';

/**
 * The IMP_MIME_Viewer_images class allows images to be displayed
 * inline in a message.
 *
 * $Horde: imp/lib/MIME/Viewer/images.php,v 1.22 2003/08/06 21:35:55 slusarz Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.22 $
 * @since   IMP 3.2
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_images extends MIME_Viewer_images {

    /**
     * Render out the currently set contents.
     *
     * @access public
     *
     * @param array $params  An array with a reference to a MIME_Contents
     *                       object.
     *
     * @return string  The rendered text in HTML.
     */
    function render($params)
    {
        $contents = &$params[0];

        global $browser;

        if ($contents->viewAsAttachment()) {
            if (!$browser->hasFeature('javascript') ||
                !$contents->viewAsAttachment(true) ||
                Horde::getFormData('img_data')) {
                return parent::render($this->mime_part);
            } else {
                return $this->_popupImageWindow();
            }
        }

        /* If render() is called outside of view.php, we need to generate
           an image tag to view.php. */
        if ($browser->isViewable($this->mime_part->getType())) {
            $alt = $this->mime_part->getName(false, true);
            return '<img src="' . $contents->urlView($this->mime_part, 'view_attach') . '" border="0" alt="' . $alt . '" title="' . $alt . '" />';
        } else {
            return $contents->formatStatusMsg(_("Your browser does not support inline display of this image type"));
        }
    }

    /**
     * Return the content-type
     *
     * @access public
     *
     * @return string  The content-type of the output.
     */
    function getType()
    {
        global $browser;

        if (MIME_Contents::viewAsAttachment() &&
            (!$browser->hasFeature('javascript') ||
             !MIME_Contents::viewAsAttachment(true) ||
             Horde::getFormData('img_data'))) {
            return parent::getType();
        } else {
            return 'text/html';
        }
    }

    /**
     * Generate the HTML output for the JS auto-resize view window.
     *
     * @access private
     *
     * @return string  The HTML output.
     */
    function _popupImageWindow()
    {
        $self_url = Horde::addParameter(Horde::selfUrl(true), 'img_data', 1);
        $title = $this->mime_part->getName(false, true);

        $str = <<<EOD
<html> 
<head> 
<title>$title</title>
<script language='javascript'> 
function resizeWindow() { 
  window.moveTo(0, 0);
  window.resizeTo(200, 200);

  width_1 = document.disp_image.width;
  width_2 = window.screen.availWidth - 20;
  width = (width_1 > width_2) ? width_2 : width_1;

  height_1 = document.disp_image.height;
  height_2 = window.screen.availTop || (window.screen.height - 20);
  height = (height_1 > height_2) ? height_2 : height_1;

  window.resizeTo(width + (200 - (document.body.clientWidth || window.innerWidth)), height + (200 - (document.body.clientHeight || window.innerHeight))); 
  window.focus(); 
}; 
</script>
</head> 
<body bgcolor="#ffffff" onload="javascript:resizeWindow();" topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<img name="disp_image" border="0" src="$self_url" style="display:block" />
</body> 
</html>
EOD;
        return $str;
    }

}
