<?php
/**
 * $Horde: forwards/main.php,v 1.24 2003/09/16 23:04:15 jan Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 */

define('FORWARDS_BASE', dirname(__FILE__));
require_once FORWARDS_BASE . '/lib/base.php';

// Create a driver.
require_once FORWARDS_BASE . '/lib/Driver.php';
$driver = &Forwards_Driver::factory();

// Get the current login username and realm.
$split = explode('@', Auth::getAuth());
$user = @$split[0]; $realm = @$split[1];
if (empty($realm)) {
    $realm = 'default';
}

$submit = Horde::getFormData('submit', false);
if ($submit) {
    $forwardmode = Horde::getFormData('mode', 'error');
    if ($forwardmode === 'error') {
        $notification->push(_("You must specify the mode (set or remove)"), 'horde.warning');
    }

    // Check for refused usernames, using current horde username

    if (in_array($user, $conf['user']['refused'])) {
        $notification->push(sprintf(_("You can't change Forwards for user %s"), $user), 'horde.error');
        $forwardmode = 'error';
    }

    $oldpassword = Horde::getFormData('oldpassword', false);
    if (!$oldpassword) {
        $notification->push(_("You must give your password"), 'horde.warning');
        $forwardmode = 'error';
    }

    $metoo = Horde::getFormData('metoo', false);
    if ($metoo != 'on') {
        $metoo = 'off';
    }

    // Do the function requested
    switch ($forwardmode) {
    case 'set':
        $forwardwhere = Horde::getFormData('where', false);
        if (!$forwardwhere) {
            $notification->push(_("You must supply an e-mail address!"), 'horde.warning');
        } else {
            if ($driver->enableForwarding($user, $realm, $oldpassword, $forwardwhere, $metoo)) {
                $notification->push(_("Forward set!"), 'horde.success');
            } else {
                $notification->push(sprintf(_("Failure in setting forward: %s"), $driver->err_str),
                                    'horde.error');
            }
        }
        break;

    case "unset":
        if ($driver->disableForwarding($user, $realm, $oldpassword)) {
            $notification->push(_("Forward removed!"), 'horde.success');
        } else {
            $notification->push(sprintf(_("Failure in removing forward: %s"), $driver->err_str),
                                'horde.error');
        }
        break;
    }
}

// If we can tell if the forwards are enabled, then say so. But if
// this fails, it could be because it is disabled, or just because we
// can't tell, so just be quiet about it.
if ($driver->isEnabledForwarding($user, $realm, Auth::getCredential('password'))) {
    $notification->push(_("Forwarding is currently enabled."), 'horde.success');
}

$title = _("Set or Remove E-Mail Forwards");
require FORWARDS_TEMPLATES . '/common-header.inc';
Forwards::menu();
require FORWARDS_TEMPLATES . '/main/javascript.inc';
require FORWARDS_TEMPLATES . '/main/main.inc';
require FORWARDS_TEMPLATES . '/common-footer.inc';
