/*
 * Copyright (c) 2011, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.visualvm.lib.profiler.api.icons;

/**
 *
 * @author Jiri Sedlacek
 */
public interface LanguageIcons extends Icons.Keys {

    public static final String CLASS = "LanguageIcons.Class"; // NOI18N
    public static final String CLASS_ANONYMOUS = "LanguageIcons.ClassAnonymous"; // NOI18N
    public static final String CONSTRUCTOR_PACKAGE = "LanguageIcons.ConstructorPackage"; // NOI18N
    public static final String CONSTRUCTOR_PRIVATE = "LanguageIcons.ConstructorPrivate"; // NOI18N
    public static final String CONSTRUCTOR_PROTECTED = "LanguageIcons.ConstructorProtected"; // NOI18N
    public static final String CONSTRUCTOR_PUBLIC = "LanguageIcons.ConstructorPublic"; // NOI18N
    public static final String CONSTRUCTORS = "LanguageIcons.Constructors"; // NOI18N
    public static final String INITIALIZER = "LanguageIcons.Initializer"; // NOI18N
    public static final String INITIALIZER_STATIC = "LanguageIcons.InitializerStatic"; // NOI18N
    public static final String INTERFACE = "LanguageIcons.Interface"; // NOI18N
    public static final String LIBRARIES = "LanguageIcons.Libraries"; // NOI18N
    public static final String METHOD_PACKAGE = "LanguageIcons.MethodPackage"; // NOI18N
    public static final String METHOD_PRIVATE = "LanguageIcons.MethodPrivate"; // NOI18N
    public static final String METHOD_PROTECTED = "LanguageIcons.MethodProtected"; // NOI18N
    public static final String METHOD_PUBLIC = "LanguageIcons.MethodPublic"; // NOI18N
    public static final String METHOD_PACKAGE_STATIC = "LanguageIcons.MethodPackageStatic"; // NOI18N
    public static final String METHOD_PRIVATE_STATIC = "LanguageIcons.MethodPrivateStatic"; // NOI18N
    public static final String METHOD_PROTECTED_STATIC = "LanguageIcons.MethodProtectedStatic"; // NOI18N
    public static final String METHOD_PUBLIC_STATIC = "LanguageIcons.MethodPublicStatic"; // NOI18N
    public static final String METHOD_INHERITED = "LanguageIcons.MethodInheritedStatic"; // NOI18N
    public static final String METHODS = "LanguageIcons.Methods"; // NOI18N
    public static final String METHOD = "LanguageIcons.Method"; // NOI18N
    public static final String PACKAGE = "LanguageIcons.Package"; // NOI18N
    public static final String VARIABLE_PACKAGE = "LanguageIcons.VariablePackage"; // NOI18N
    public static final String VARIABLE_PRIVATE = "LanguageIcons.VariablePrivate"; // NOI18N
    public static final String VARIABLE_PROTECTED = "LanguageIcons.VariableProtected"; // NOI18N
    public static final String VARIABLE_PUBLIC = "LanguageIcons.VariablePublic"; // NOI18N
    public static final String VARIABLE_PACKAGE_STATIC = "LanguageIcons.VariablePackageStatic"; // NOI18N
    public static final String VARIABLE_PRIVATE_STATIC = "LanguageIcons.VariablePrivateStatic"; // NOI18N
    public static final String VARIABLE_PROTECTED_STATIC = "LanguageIcons.VariableProtectedStatic"; // NOI18N
    public static final String VARIABLE_PUBLIC_STATIC = "LanguageIcons.VariablePublicStatic"; // NOI18N
    public static final String VARIABLES = "LanguageIcons.Variables"; // NOI18N
    public static final String ARRAY = "LanguageIcons.Array"; // NOI18N
    public static final String INSTANCE = "LanguageIcons.Instance"; // NOI18N
    public static final String PRIMITIVE = "LanguageIcons.Primitive"; // NOI18N
    public static final String JAR = "LanguangeIcons.Jar"; // NOI18N
}
