# $Id: dvipdfmx.pl 24659 2011-11-25 01:06:07Z preining $
# post action for dvipdfmx to handle upgrades of map files
# Copyright 2011 Norbert Preining
# This file is licensed under the GNU General Public License version 2
# or any later version.
#

my $texdir;
my $mode;

BEGIN {
  $^W = 1;
  $mode = lc($ARGV[0]);
  $texdir = $ARGV[1];
  # make Perl find our packages first:
  unshift (@INC, "$texdir/tlpkg");
}
use TeXLive::TLUtils qw(win32 mkdirhier conv_to_w32_path log info);

if ($mode eq 'install') {
  do_install();
} elsif ($mode eq 'remove') {
  do_remove();
} else {
  die("unknown mode: $mode\n");
}

sub do_remove {
  # do nothing
}

sub do_install {
  # bin-installs font-config related stuff
  chomp( my $tmfsysconf = `kpsewhich -var-value=TEXMFSYSCONFIG` ) ;
  chomp( my $tmfmain = `kpsewhich -var-value=TEXMFMAIN` ) ;
  if (-r "$tmfsysconf/dvipdfmx/dvipdfmx.cfg") {
    # assume that succeeds, we tested -r above!
    open (FOO, "<$tmfsysconf/dvipdfmx/dvipdfmx.cfg");
    my @lines = <FOO>;
    chomp(@lines);
    close(FOO);
    my @outlines;
    my $isold = 0;
    for my $l (@lines) {
      if ($l =~ m/^f\s+cid-x\.map\s*$/) {
        $isold = 1;
        push @outlines, "%f cid-x.map\n\n";
        push @outlines, "% the following file is generated by updmap(-sys) from the 
% KanjiMap entries in the updmap.cfg file.
f kanjix.map
% minimal example for Chinese and Korean users
% improvements please to tex-live\@tug.org
f ckx.map\n";
      } else {
        push @outlines, "$l\n";
      }
    }
    if ($isold) {
      if (!open (FOO, ">$tmfsysconf/dvipdfmx/dvipdfmx.cfg")) {
        fprintf STDERR "dvipdfmx.pl(postcode): Cannot write $tmfsysconf/dvipdfmx/dvipdfmx.cfg
  This config file contains an outdated map definition line.
  Please see $tmfmain/dvipdfmx/dvipdfmx.cfg for changes
";
        return 0;
      }
      print FOO @outlines;
      close (FOO);
    }
  }
  return 0;
}

### Local Variables:
### perl-indent-level: 2
### tab-width: 2
### indent-tabs-mode: nil
### End:
# vim:set tabstop=2 expandtab: #
