// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Webcam.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.webcam {

  public class Controls : ICloneable {
    public object Clone() {
      Controls copy = new Controls();
      copy.brightness = this.brightness;
      copy.contrast = this.contrast;
      copy.saturation = this.saturation;
      copy.gain = this.gain;
      copy.gamma = this.gamma;
      copy.powerLineFrequency = this.powerLineFrequency;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["brightness"] = this.brightness;
      json["contrast"] = this.contrast;
      json["saturation"] = this.saturation;
      json["gain"] = this.gain;
      json["gamma"] = this.gamma;
      json["powerLineFrequency"] = (int)this.powerLineFrequency;
      return json;
    }

    public static Controls Decode(LightJson.JsonObject json, Agent agent) {
      Controls inst = new Controls();
      inst.brightness = (int)json["brightness"];
      inst.contrast = (int)json["contrast"];
      inst.saturation = (int)json["saturation"];
      inst.gain = (int)json["gain"];
      inst.gamma = (int)json["gamma"];
      inst.powerLineFrequency = (Com.Raritan.Idl.webcam.PowerLineFrequency)(int)json["powerLineFrequency"];
      return inst;
    }

    public int brightness = 0;
    public int contrast = 0;
    public int saturation = 0;
    public int gain = 0;
    public int gamma = 0;
    public Com.Raritan.Idl.webcam.PowerLineFrequency powerLineFrequency = Com.Raritan.Idl.webcam.PowerLineFrequency.NOT_SUPPORTED;
  }
}
