% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context}
\alias{context}
\alias{n}
\alias{cur_group}
\alias{cur_group_id}
\alias{cur_group_rows}
\alias{cur_column}
\title{Information about the "current" group or variable}
\usage{
n()

cur_group()

cur_group_id()

cur_group_rows()

cur_column()
}
\description{
These functions return information about the "current" group or "current"
variable, so only work inside specific contexts like \code{\link[=summarise]{summarise()}} and
\code{\link[=mutate]{mutate()}}.
\itemize{
\item \code{n()} gives the current group size.
\item \code{cur_group()} gives the group keys, a tibble with one row and one column
for each grouping variable.
\item \code{cur_group_id()} gives a unique numeric identifier for the current group.
\item \code{cur_group_rows()} gives the row indices for the current group.
\item \code{cur_column()} gives the name of the current column (in \code{\link[=across]{across()}} only).
}

See \code{\link[=group_data]{group_data()}} for equivalent functions that return values for all
groups.

See \code{\link[=pick]{pick()}} for a way to select a subset of columns using tidyselect syntax
while inside \code{summarise()} or \code{mutate()}.
}
\section{data.table}{

If you're familiar with data.table:
\itemize{
\item \code{cur_group_id()} <-> \code{.GRP}
\item \code{cur_group()} <-> \code{.BY}
\item \code{cur_group_rows()} <-> \code{.I}
}

See \code{\link[=pick]{pick()}} for an equivalent to \code{.SD}.
}

\examples{
df <- tibble(
  g = sample(rep(letters[1:3], 1:3)),
  x = runif(6),
  y = runif(6)
)
gf <- df \%>\% group_by(g)

gf \%>\% summarise(n = n())

gf \%>\% mutate(id = cur_group_id())
gf \%>\% reframe(row = cur_group_rows())
gf \%>\% summarise(data = list(cur_group()))

gf \%>\% mutate(across(everything(), ~ paste(cur_column(), round(.x, 2))))
}
