% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colWeightedMads,dgCMatrix-method}
\alias{colWeightedMads,dgCMatrix-method}
\alias{rowWeightedMads,dgCMatrix-method}
\title{Calculates the weighted median absolute deviation for each row (column) of a
matrix-like object}
\usage{
\S4method{colWeightedMads}{dgCMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  constant = 1.4826,
  center = NULL
)

\S4method{rowWeightedMads}{dgCMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  constant = 1.4826
)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{constant}{A scale factor. See \code{stats::\link[stats]{mad}()} for
details.}

\item{center}{Not supported at the moment.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted  median absolute deviation for each row (column) of
a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowWeightedMads}
/ \code{matrixStats::colWeightedMads}.
}
\examples{
  mat <- matrix(0, nrow=10, ncol=5)
  mat[sample(prod(dim(mat)), 25)] <- rpois(n=25, 5)
  sp_mat <- as(mat, "dgCMatrix")
  weights <- rnorm(10, mean=1, sd=0.1)

  # sparse version
  sparseMatrixStats::colWeightedMads(sp_mat, weights)

  # Attention the result differs from matrixStats
  # because it always uses 'interpolate=FALSE'.
  matrixStats::colWeightedMads(mat, weights)

}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedMad]{rowWeightedMads}()} and
\code{matrixStats::\link[matrixStats:weightedMad]{colWeightedMads}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link[MatrixGenerics]{rowMads} for the corresponding unweighted function.
}
}
