% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringQualityMetrics.R
\docType{methods}
\name{iqrPlot,RccSet-method}
\alias{iqrPlot,RccSet-method}
\alias{iqrPlot}
\title{iqrPlot}
\usage{
\S4method{iqrPlot}{RccSet}(rccSet, codeClass = c("Negative", "Positive",
  "Endogenous", "Housekeeping"), method = c("cutoffByMMAD", "cutoffByVar"),
  stringency = 4)
}
\arguments{
\item{rccSet}{An RccSet object}

\item{codeClass}{Character string specifying the code class (as annotated in the
fData(rccSet)$CodeClass column) for which the IQR shall be determined.}

\item{method}{Character string specifying the method for outlier detection: either
"cutoffByMMAD" or "cutoffByVar".}

\item{stringency}{Numeric value passed to the cutoff function specified by the method
argument (see the 'd' argument of cutoffByMMAD and cutoffByVar).}
}
\value{
A plot
}
\description{
Plot the interquartile range (IQR) for a certain code class of probes in an
RccSet object.
}
\details{
IQR of the specified code class for each sample in the RccSet are plotted
and outliers (as determined by the function specified in the method
argument) are marked in red (thresholds for outlier definition are plotted
as red dashed lines).
}
\seealso{
\code{\link{cutoffByMMAD}}, \code{\link{cutoffByVar}}
}
\author{
Dorothee Nickles
}
