# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class DirectoryOperations(object):
    """DirectoryOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.storage.blob.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def create(
        self,
        timeout=None,  # type: Optional[int]
        directory_properties=None,  # type: Optional[str]
        posix_permissions=None,  # type: Optional[str]
        posix_umask=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        directory_http_headers=None,  # type: Optional["_models.DirectoryHttpHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Create a directory. By default, the destination is overwritten and if the destination already
        exists and has a lease the lease is broken. This operation supports conditional HTTP requests.
        For more information, see `Specifying Conditional Headers for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-
        blob-service-operations>`_.  To fail if the destination already exists, use a conditional
        request with If-None-Match: "*".

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param directory_properties: Optional.  User-defined properties to be stored with the file or
         directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2, ...",
         where each value is base64 encoded.
        :type directory_properties: str
        :param posix_permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type posix_permissions: str
        :param posix_umask: Only valid if Hierarchical Namespace is enabled for the account. This umask
         restricts permission settings for file and directory, and will only be applied when default Acl
         does not exist in parent directory. If the umask bit has set, it means that the corresponding
         permission will be disabled. Otherwise the corresponding permission will be determined by the
         permission. A 4-digit octal notation (e.g. 0022) is supported here. If no umask was specified,
         a default umask - 0027 will be used.
        :type posix_umask: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param directory_http_headers: Parameter group.
        :type directory_http_headers: ~azure.storage.blob.models.DirectoryHttpHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _cache_control = None
        _content_type = None
        _content_encoding = None
        _content_language = None
        _content_disposition = None
        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        if directory_http_headers is not None:
            _cache_control = directory_http_headers.cache_control
            _content_type = directory_http_headers.content_type
            _content_encoding = directory_http_headers.content_encoding
            _content_language = directory_http_headers.content_language
            _content_disposition = directory_http_headers.content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
        resource = "directory"
        accept = "application/xml"

        # Construct URL
        url = self.create.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['resource'] = self._serialize.query("resource", resource, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if directory_properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("directory_properties", directory_properties, 'str')
        if posix_permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("posix_permissions", posix_permissions, 'str')
        if posix_umask is not None:
            header_parameters['x-ms-umask'] = self._serialize.header("posix_umask", posix_umask, 'str')
        if _cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", _cache_control, 'str')
        if _content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", _content_type, 'str')
        if _content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", _content_encoding, 'str')
        if _content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", _content_language, 'str')
        if _content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", _content_disposition, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    create.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def rename(
        self,
        rename_source,  # type: str
        timeout=None,  # type: Optional[int]
        marker=None,  # type: Optional[str]
        path_rename_mode=None,  # type: Optional[Union[str, "_models.PathRenameMode"]]
        directory_properties=None,  # type: Optional[str]
        posix_permissions=None,  # type: Optional[str]
        posix_umask=None,  # type: Optional[str]
        source_lease_id=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        directory_http_headers=None,  # type: Optional["_models.DirectoryHttpHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        source_modified_access_conditions=None,  # type: Optional["_models.SourceModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Rename a directory. By default, the destination is overwritten and if the destination already
        exists and has a lease the lease is broken. This operation supports conditional HTTP requests.
        For more information, see `Specifying Conditional Headers for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-
        blob-service-operations>`_. To fail if the destination already exists, use a conditional
        request with If-None-Match: "*".

        :param rename_source: The file or directory to be renamed. The value must have the following
         format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
         overwrite the existing properties; otherwise, the existing properties will be preserved.
        :type rename_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param marker: When renaming a directory, the number of paths that are renamed with each
         invocation is limited.  If the number of paths to be renamed exceeds this limit, a continuation
         token is returned in this response header.  When a continuation token is returned in the
         response, it must be specified in a subsequent invocation of the rename operation to continue
         renaming the directory.
        :type marker: str
        :param path_rename_mode: Determines the behavior of the rename operation.
        :type path_rename_mode: str or ~azure.storage.blob.models.PathRenameMode
        :param directory_properties: Optional.  User-defined properties to be stored with the file or
         directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2, ...",
         where each value is base64 encoded.
        :type directory_properties: str
        :param posix_permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type posix_permissions: str
        :param posix_umask: Only valid if Hierarchical Namespace is enabled for the account. This umask
         restricts permission settings for file and directory, and will only be applied when default Acl
         does not exist in parent directory. If the umask bit has set, it means that the corresponding
         permission will be disabled. Otherwise the corresponding permission will be determined by the
         permission. A 4-digit octal notation (e.g. 0022) is supported here. If no umask was specified,
         a default umask - 0027 will be used.
        :type posix_umask: str
        :param source_lease_id: A lease ID for the source path. If specified, the source path must have
         an active lease and the lease ID must match.
        :type source_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param directory_http_headers: Parameter group.
        :type directory_http_headers: ~azure.storage.blob.models.DirectoryHttpHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param source_modified_access_conditions: Parameter group.
        :type source_modified_access_conditions: ~azure.storage.blob.models.SourceModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _cache_control = None
        _content_type = None
        _content_encoding = None
        _content_language = None
        _content_disposition = None
        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        if directory_http_headers is not None:
            _cache_control = directory_http_headers.cache_control
            _content_type = directory_http_headers.content_type
            _content_encoding = directory_http_headers.content_encoding
            _content_language = directory_http_headers.content_language
            _content_disposition = directory_http_headers.content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
        if source_modified_access_conditions is not None:
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match
        accept = "application/xml"

        # Construct URL
        url = self.rename.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if marker is not None:
            query_parameters['continuation'] = self._serialize.query("marker", marker, 'str')
        if path_rename_mode is not None:
            query_parameters['mode'] = self._serialize.query("path_rename_mode", path_rename_mode, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-rename-source'] = self._serialize.header("rename_source", rename_source, 'str')
        if directory_properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("directory_properties", directory_properties, 'str')
        if posix_permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("posix_permissions", posix_permissions, 'str')
        if posix_umask is not None:
            header_parameters['x-ms-umask'] = self._serialize.header("posix_umask", posix_umask, 'str')
        if _cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", _cache_control, 'str')
        if _content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", _content_type, 'str')
        if _content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", _content_encoding, 'str')
        if _content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", _content_language, 'str')
        if _content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", _content_disposition, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if source_lease_id is not None:
            header_parameters['x-ms-source-lease-id'] = self._serialize.header("source_lease_id", source_lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _source_if_modified_since is not None:
            header_parameters['x-ms-source-if-modified-since'] = self._serialize.header("source_if_modified_since", _source_if_modified_since, 'rfc-1123')
        if _source_if_unmodified_since is not None:
            header_parameters['x-ms-source-if-unmodified-since'] = self._serialize.header("source_if_unmodified_since", _source_if_unmodified_since, 'rfc-1123')
        if _source_if_match is not None:
            header_parameters['x-ms-source-if-match'] = self._serialize.header("source_if_match", _source_if_match, 'str')
        if _source_if_none_match is not None:
            header_parameters['x-ms-source-if-none-match'] = self._serialize.header("source_if_none_match", _source_if_none_match, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-continuation']=self._deserialize('str', response.headers.get('x-ms-continuation'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    rename.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def delete(
        self,
        recursive_directory_delete,  # type: bool
        timeout=None,  # type: Optional[int]
        marker=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Deletes the directory.

        :param recursive_directory_delete: If "true", all paths beneath the directory will be deleted.
         If "false" and the directory is non-empty, an error occurs.
        :type recursive_directory_delete: bool
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param marker: When renaming a directory, the number of paths that are renamed with each
         invocation is limited.  If the number of paths to be renamed exceeds this limit, a continuation
         token is returned in this response header.  When a continuation token is returned in the
         response, it must be specified in a subsequent invocation of the rename operation to continue
         renaming the directory.
        :type marker: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
        accept = "application/xml"

        # Construct URL
        url = self.delete.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['recursive'] = self._serialize.query("recursive_directory_delete", recursive_directory_delete, 'bool')
        if marker is not None:
            query_parameters['continuation'] = self._serialize.query("marker", marker, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-continuation']=self._deserialize('str', response.headers.get('x-ms-continuation'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def set_access_control(
        self,
        timeout=None,  # type: Optional[int]
        owner=None,  # type: Optional[str]
        group=None,  # type: Optional[str]
        posix_permissions=None,  # type: Optional[str]
        posix_acl=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Set the owner, group, permissions, or access control list for a directory.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param owner: Optional. The owner of the blob or directory.
        :type owner: str
        :param group: Optional. The owning group of the blob or directory.
        :type group: str
        :param posix_permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type posix_permissions: str
        :param posix_acl: Sets POSIX access control rights on files and directories. The value is a
         comma-separated list of access control entries. Each access control entry (ACE) consists of a
         scope, a type, a user or group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type posix_acl: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        action = "setAccessControl"
        accept = "application/xml"

        # Construct URL
        url = self.set_access_control.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if owner is not None:
            header_parameters['x-ms-owner'] = self._serialize.header("owner", owner, 'str')
        if group is not None:
            header_parameters['x-ms-group'] = self._serialize.header("group", group, 'str')
        if posix_permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("posix_permissions", posix_permissions, 'str')
        if posix_acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("posix_acl", posix_acl, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_access_control.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def get_access_control(
        self,
        timeout=None,  # type: Optional[int]
        upn=None,  # type: Optional[bool]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Get the owner, group, permissions, or access control list for a directory.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param upn: Optional. Valid only when Hierarchical Namespace is enabled for the account. If
         "true", the identity values returned in the x-ms-owner, x-ms-group, and x-ms-acl response
         headers will be transformed from Azure Active Directory Object IDs to User Principal Names.  If
         "false", the values will be returned as Azure Active Directory Object IDs. The default value is
         false.
        :type upn: bool
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        action = "getAccessControl"
        accept = "application/xml"

        # Construct URL
        url = self.get_access_control.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if upn is not None:
            query_parameters['upn'] = self._serialize.query("upn", upn, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-owner']=self._deserialize('str', response.headers.get('x-ms-owner'))
        response_headers['x-ms-group']=self._deserialize('str', response.headers.get('x-ms-group'))
        response_headers['x-ms-permissions']=self._deserialize('str', response.headers.get('x-ms-permissions'))
        response_headers['x-ms-acl']=self._deserialize('str', response.headers.get('x-ms-acl'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    get_access_control.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore
