# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters body to pass for resource name availability check.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name.
    :type name: str
    :param type: Required. Resource type. The only legal value of this property for checking redis
     cache name availability is 'Microsoft.Cache/redis'.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']


class ExportRDBParameters(msrest.serialization.Model):
    """Parameters for Redis export operation.

    All required parameters must be populated in order to send to Azure.

    :param format: File format.
    :type format: str
    :param prefix: Required. Prefix to use for exported files.
    :type prefix: str
    :param container: Required. Container name to export to.
    :type container: str
    """

    _validation = {
        'prefix': {'required': True},
        'container': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
        'container': {'key': 'container', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportRDBParameters, self).__init__(**kwargs)
        self.format = kwargs.get('format', None)
        self.prefix = kwargs['prefix']
        self.container = kwargs['container']


class ImportRDBParameters(msrest.serialization.Model):
    """Parameters for Redis import operation.

    All required parameters must be populated in order to send to Azure.

    :param format: File format.
    :type format: str
    :param files: Required. files to import.
    :type files: list[str]
    """

    _validation = {
        'files': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'files': {'key': 'files', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportRDBParameters, self).__init__(**kwargs)
        self.format = kwargs.get('format', None)
        self.files = kwargs['files']


class NotificationListResponse(msrest.serialization.Model):
    """The response of listUpgradeNotifications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of all notifications.
    :type value: list[~azure.mgmt.redis.models.UpgradeNotification]
    :ivar next_link: Link for next set of notifications.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpgradeNotification]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotificationListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class Operation(msrest.serialization.Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.redis.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: Operation type: read, write, delete, listKeys/action, etc.
    :type operation: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param description: Friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by the resource provider.
    :type value: list[~azure.mgmt.redis.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class Resource(msrest.serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class RedisAccessKeys(msrest.serialization.Model):
    """Redis cache access keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_key: The current primary key that clients can use to authenticate with Redis
     cache.
    :vartype primary_key: str
    :ivar secondary_key: The current secondary key that clients can use to authenticate with Redis
     cache.
    :vartype secondary_key: str
    """

    _validation = {
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisAccessKeys, self).__init__(**kwargs)
        self.primary_key = None
        self.secondary_key = None


class RedisCommonProperties(msrest.serialization.Model):
    """Create/Update/Get common properties of the redis cache.

    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    """

    _attribute_map = {
        'redis_configuration': {'key': 'redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisCommonProperties, self).__init__(**kwargs)
        self.redis_configuration = kwargs.get('redis_configuration', None)
        self.enable_non_ssl_port = kwargs.get('enable_non_ssl_port', None)
        self.replicas_per_master = kwargs.get('replicas_per_master', None)
        self.tenant_settings = kwargs.get('tenant_settings', None)
        self.shard_count = kwargs.get('shard_count', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)


class RedisCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :param zones: A list of availability zones denoting where the resource needs to come from.
    :type zones: list[str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache inside an existing
     Azure Virtual Network.
    :type static_ip: str
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
    }

    _attribute_map = {
        'zones': {'key': 'zones', 'type': '[str]'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'properties.replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIP', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisCreateParameters, self).__init__(**kwargs)
        self.zones = kwargs.get('zones', None)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.redis_configuration = kwargs.get('redis_configuration', None)
        self.enable_non_ssl_port = kwargs.get('enable_non_ssl_port', None)
        self.replicas_per_master = kwargs.get('replicas_per_master', None)
        self.tenant_settings = kwargs.get('tenant_settings', None)
        self.shard_count = kwargs.get('shard_count', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.sku = kwargs['sku']
        self.subnet_id = kwargs.get('subnet_id', None)
        self.static_ip = kwargs.get('static_ip', None)


class RedisCreateProperties(RedisCommonProperties):
    """Properties supplied to Create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache inside an existing
     Azure Virtual Network.
    :type static_ip: str
    """

    _validation = {
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
    }

    _attribute_map = {
        'redis_configuration': {'key': 'redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'static_ip': {'key': 'staticIP', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisCreateProperties, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.subnet_id = kwargs.get('subnet_id', None)
        self.static_ip = kwargs.get('static_ip', None)


class RedisFirewallRule(Resource):
    """A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_ip: Required. lowest IP address included in the range.
    :type start_ip: str
    :param end_ip: Required. highest IP address included in the range.
    :type end_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip': {'required': True},
        'end_ip': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip': {'key': 'properties.startIP', 'type': 'str'},
        'end_ip': {'key': 'properties.endIP', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisFirewallRule, self).__init__(**kwargs)
        self.start_ip = kwargs['start_ip']
        self.end_ip = kwargs['end_ip']


class RedisFirewallRuleCreateParameters(msrest.serialization.Model):
    """Parameters required for creating a firewall rule on redis cache.

    All required parameters must be populated in order to send to Azure.

    :param start_ip: Required. lowest IP address included in the range.
    :type start_ip: str
    :param end_ip: Required. highest IP address included in the range.
    :type end_ip: str
    """

    _validation = {
        'start_ip': {'required': True},
        'end_ip': {'required': True},
    }

    _attribute_map = {
        'start_ip': {'key': 'properties.startIP', 'type': 'str'},
        'end_ip': {'key': 'properties.endIP', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisFirewallRuleCreateParameters, self).__init__(**kwargs)
        self.start_ip = kwargs['start_ip']
        self.end_ip = kwargs['end_ip']


class RedisFirewallRuleListResult(msrest.serialization.Model):
    """The response of list firewall rules Redis operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Results of the list firewall rules operation.
    :type value: list[~azure.mgmt.redis.models.RedisFirewallRule]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RedisFirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisFirewallRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class RedisForceRebootResponse(msrest.serialization.Model):
    """Response to force reboot for Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Status message.
    :vartype message: str
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisForceRebootResponse, self).__init__(**kwargs)
        self.message = None


class RedisInstanceDetails(msrest.serialization.Model):
    """Details of single instance of redis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssl_port: Redis instance SSL port.
    :vartype ssl_port: int
    :ivar non_ssl_port: If enableNonSslPort is true, provides Redis instance Non-SSL port.
    :vartype non_ssl_port: int
    :ivar zone: If the Cache uses availability zones, specifies availability zone where this
     instance is located.
    :vartype zone: str
    :ivar shard_id: If clustering is enabled, the Shard ID of Redis Instance.
    :vartype shard_id: int
    :ivar is_master: Specifies whether the instance is a master node.
    :vartype is_master: bool
    """

    _validation = {
        'ssl_port': {'readonly': True},
        'non_ssl_port': {'readonly': True},
        'zone': {'readonly': True},
        'shard_id': {'readonly': True},
        'is_master': {'readonly': True},
    }

    _attribute_map = {
        'ssl_port': {'key': 'sslPort', 'type': 'int'},
        'non_ssl_port': {'key': 'nonSslPort', 'type': 'int'},
        'zone': {'key': 'zone', 'type': 'str'},
        'shard_id': {'key': 'shardId', 'type': 'int'},
        'is_master': {'key': 'isMaster', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisInstanceDetails, self).__init__(**kwargs)
        self.ssl_port = None
        self.non_ssl_port = None
        self.zone = None
        self.shard_id = None
        self.is_master = None


class RedisLinkedServer(msrest.serialization.Model):
    """Linked server Id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Linked server Id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisLinkedServer, self).__init__(**kwargs)
        self.id = None


class RedisLinkedServerCreateParameters(msrest.serialization.Model):
    """Parameter required for creating a linked server to redis cache.

    All required parameters must be populated in order to send to Azure.

    :param linked_redis_cache_id: Required. Fully qualified resourceId of the linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Required. Location of the linked redis cache.
    :type linked_redis_cache_location: str
    :param server_role: Required. Role of the linked server. Possible values include: "Primary",
     "Secondary".
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    """

    _validation = {
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
    }

    _attribute_map = {
        'linked_redis_cache_id': {'key': 'properties.linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'properties.linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisLinkedServerCreateParameters, self).__init__(**kwargs)
        self.linked_redis_cache_id = kwargs['linked_redis_cache_id']
        self.linked_redis_cache_location = kwargs['linked_redis_cache_location']
        self.server_role = kwargs['server_role']


class RedisLinkedServerCreateProperties(msrest.serialization.Model):
    """Create properties for a linked server.

    All required parameters must be populated in order to send to Azure.

    :param linked_redis_cache_id: Required. Fully qualified resourceId of the linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Required. Location of the linked redis cache.
    :type linked_redis_cache_location: str
    :param server_role: Required. Role of the linked server. Possible values include: "Primary",
     "Secondary".
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    """

    _validation = {
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
    }

    _attribute_map = {
        'linked_redis_cache_id': {'key': 'linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'serverRole', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisLinkedServerCreateProperties, self).__init__(**kwargs)
        self.linked_redis_cache_id = kwargs['linked_redis_cache_id']
        self.linked_redis_cache_location = kwargs['linked_redis_cache_location']
        self.server_role = kwargs['server_role']


class RedisLinkedServerProperties(RedisLinkedServerCreateProperties):
    """Properties of a linked server to be returned in get/put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param linked_redis_cache_id: Required. Fully qualified resourceId of the linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Required. Location of the linked redis cache.
    :type linked_redis_cache_location: str
    :param server_role: Required. Role of the linked server. Possible values include: "Primary",
     "Secondary".
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar provisioning_state: Terminal state of the link between primary and secondary redis cache.
    :vartype provisioning_state: str
    """

    _validation = {
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'linked_redis_cache_id': {'key': 'linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'serverRole', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisLinkedServerProperties, self).__init__(**kwargs)
        self.provisioning_state = None


class RedisLinkedServerWithProperties(Resource):
    """Response to put/get linked server (with properties) for Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param linked_redis_cache_id: Fully qualified resourceId of the linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Location of the linked redis cache.
    :type linked_redis_cache_location: str
    :param server_role: Role of the linked server. Possible values include: "Primary", "Secondary".
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar provisioning_state: Terminal state of the link between primary and secondary redis cache.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_redis_cache_id': {'key': 'properties.linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'properties.linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisLinkedServerWithProperties, self).__init__(**kwargs)
        self.linked_redis_cache_id = kwargs.get('linked_redis_cache_id', None)
        self.linked_redis_cache_location = kwargs.get('linked_redis_cache_location', None)
        self.server_role = kwargs.get('server_role', None)
        self.provisioning_state = None


class RedisLinkedServerWithPropertiesList(msrest.serialization.Model):
    """List of linked servers (with properties) of a Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of linked servers (with properties) of a Redis cache.
    :type value: list[~azure.mgmt.redis.models.RedisLinkedServerWithProperties]
    :ivar next_link: Link for next set.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RedisLinkedServerWithProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisLinkedServerWithPropertiesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class RedisListResult(msrest.serialization.Model):
    """The response of list Redis operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Redis cache instances.
    :type value: list[~azure.mgmt.redis.models.RedisResource]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RedisResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class RedisPatchSchedule(Resource):
    """Response to put/get patch schedules for Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param schedule_entries: Required. List of patch schedules for a Redis cache.
    :type schedule_entries: list[~azure.mgmt.redis.models.ScheduleEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'schedule_entries': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'schedule_entries': {'key': 'properties.scheduleEntries', 'type': '[ScheduleEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisPatchSchedule, self).__init__(**kwargs)
        self.schedule_entries = kwargs['schedule_entries']


class RedisPatchScheduleListResult(msrest.serialization.Model):
    """The response of list patch schedules Redis operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Results of the list patch schedules operation.
    :type value: list[~azure.mgmt.redis.models.RedisPatchSchedule]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RedisPatchSchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisPatchScheduleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class RedisProperties(RedisCreateProperties):
    """Properties of the redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache inside an existing
     Azure Virtual Network.
    :type static_ip: str
    :ivar redis_version: Redis version.
    :vartype redis_version: str
    :ivar provisioning_state: Redis instance provisioning status. Possible values include:
     "Creating", "Deleting", "Disabled", "Failed", "Linking", "Provisioning",
     "RecoveringScaleFailure", "Scaling", "Succeeded", "Unlinking", "Unprovisioning", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.redis.models.ProvisioningState
    :ivar host_name: Redis host name.
    :vartype host_name: str
    :ivar port: Redis non-SSL port.
    :vartype port: int
    :ivar ssl_port: Redis SSL port.
    :vartype ssl_port: int
    :ivar access_keys: The keys of the Redis cache - not set if this object is not the response to
     Create or Update redis cache.
    :vartype access_keys: ~azure.mgmt.redis.models.RedisAccessKeys
    :ivar linked_servers: List of the linked servers associated with the cache.
    :vartype linked_servers: list[~azure.mgmt.redis.models.RedisLinkedServer]
    :ivar instances: List of the Redis instances associated with the cache.
    :vartype instances: list[~azure.mgmt.redis.models.RedisInstanceDetails]
    """

    _validation = {
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
        'redis_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'host_name': {'readonly': True},
        'port': {'readonly': True},
        'ssl_port': {'readonly': True},
        'access_keys': {'readonly': True},
        'linked_servers': {'readonly': True},
        'instances': {'readonly': True},
    }

    _attribute_map = {
        'redis_configuration': {'key': 'redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'static_ip': {'key': 'staticIP', 'type': 'str'},
        'redis_version': {'key': 'redisVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'ssl_port': {'key': 'sslPort', 'type': 'int'},
        'access_keys': {'key': 'accessKeys', 'type': 'RedisAccessKeys'},
        'linked_servers': {'key': 'linkedServers', 'type': '[RedisLinkedServer]'},
        'instances': {'key': 'instances', 'type': '[RedisInstanceDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisProperties, self).__init__(**kwargs)
        self.redis_version = None
        self.provisioning_state = None
        self.host_name = None
        self.port = None
        self.ssl_port = None
        self.access_keys = None
        self.linked_servers = None
        self.instances = None


class RedisRebootParameters(msrest.serialization.Model):
    """Specifies which Redis node(s) to reboot.

    :param reboot_type: Which Redis node(s) to reboot. Depending on this value data loss is
     possible. Possible values include: "PrimaryNode", "SecondaryNode", "AllNodes".
    :type reboot_type: str or ~azure.mgmt.redis.models.RebootType
    :param shard_id: If clustering is enabled, the ID of the shard to be rebooted.
    :type shard_id: int
    :param ports: A list of redis instances to reboot, specified by per-instance SSL ports or non-
     SSL ports.
    :type ports: list[int]
    """

    _attribute_map = {
        'reboot_type': {'key': 'rebootType', 'type': 'str'},
        'shard_id': {'key': 'shardId', 'type': 'int'},
        'ports': {'key': 'ports', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisRebootParameters, self).__init__(**kwargs)
        self.reboot_type = kwargs.get('reboot_type', None)
        self.shard_id = kwargs.get('shard_id', None)
        self.ports = kwargs.get('ports', None)


class RedisRegenerateKeyParameters(msrest.serialization.Model):
    """Specifies which Redis access keys to reset.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The Redis access key to regenerate. Possible values include:
     "Primary", "Secondary".
    :type key_type: str or ~azure.mgmt.redis.models.RedisKeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class RedisResource(TrackedResource):
    """A single Redis item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param zones: A list of availability zones denoting where the resource needs to come from.
    :type zones: list[str]
    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache inside an existing
     Azure Virtual Network.
    :type static_ip: str
    :ivar redis_version: Redis version.
    :vartype redis_version: str
    :ivar provisioning_state: Redis instance provisioning status. Possible values include:
     "Creating", "Deleting", "Disabled", "Failed", "Linking", "Provisioning",
     "RecoveringScaleFailure", "Scaling", "Succeeded", "Unlinking", "Unprovisioning", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.redis.models.ProvisioningState
    :ivar host_name: Redis host name.
    :vartype host_name: str
    :ivar port: Redis non-SSL port.
    :vartype port: int
    :ivar ssl_port: Redis SSL port.
    :vartype ssl_port: int
    :ivar access_keys: The keys of the Redis cache - not set if this object is not the response to
     Create or Update redis cache.
    :vartype access_keys: ~azure.mgmt.redis.models.RedisAccessKeys
    :ivar linked_servers: List of the linked servers associated with the cache.
    :vartype linked_servers: list[~azure.mgmt.redis.models.RedisLinkedServer]
    :ivar instances: List of the Redis instances associated with the cache.
    :vartype instances: list[~azure.mgmt.redis.models.RedisInstanceDetails]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
        'redis_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'host_name': {'readonly': True},
        'port': {'readonly': True},
        'ssl_port': {'readonly': True},
        'access_keys': {'readonly': True},
        'linked_servers': {'readonly': True},
        'instances': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'properties.replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIP', 'type': 'str'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'ssl_port': {'key': 'properties.sslPort', 'type': 'int'},
        'access_keys': {'key': 'properties.accessKeys', 'type': 'RedisAccessKeys'},
        'linked_servers': {'key': 'properties.linkedServers', 'type': '[RedisLinkedServer]'},
        'instances': {'key': 'properties.instances', 'type': '[RedisInstanceDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisResource, self).__init__(**kwargs)
        self.zones = kwargs.get('zones', None)
        self.redis_configuration = kwargs.get('redis_configuration', None)
        self.enable_non_ssl_port = kwargs.get('enable_non_ssl_port', None)
        self.replicas_per_master = kwargs.get('replicas_per_master', None)
        self.tenant_settings = kwargs.get('tenant_settings', None)
        self.shard_count = kwargs.get('shard_count', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.sku = kwargs['sku']
        self.subnet_id = kwargs.get('subnet_id', None)
        self.static_ip = kwargs.get('static_ip', None)
        self.redis_version = None
        self.provisioning_state = None
        self.host_name = None
        self.port = None
        self.ssl_port = None
        self.access_keys = None
        self.linked_servers = None
        self.instances = None


class RedisUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Update Redis operation.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param sku: The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'properties.replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.redis_configuration = kwargs.get('redis_configuration', None)
        self.enable_non_ssl_port = kwargs.get('enable_non_ssl_port', None)
        self.replicas_per_master = kwargs.get('replicas_per_master', None)
        self.tenant_settings = kwargs.get('tenant_settings', None)
        self.shard_count = kwargs.get('shard_count', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.sku = kwargs.get('sku', None)


class RedisUpdateProperties(RedisCommonProperties):
    """Patchable properties of the redis cache.

    :param redis_configuration: All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-
     storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-
     keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-
     entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-
     entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
    :type redis_configuration: dict[str, str]
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per master.
    :type replicas_per_master: int
    :param tenant_settings: A dictionary of tenant settings.
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param sku: The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    """

    _attribute_map = {
        'redis_configuration': {'key': 'redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'replicasPerMaster', 'type': 'int'},
        'tenant_settings': {'key': 'tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedisUpdateProperties, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)


class ScheduleEntry(msrest.serialization.Model):
    """Patch schedule entry for a Premium Redis Cache.

    All required parameters must be populated in order to send to Azure.

    :param day_of_week: Required. Day of the week when a cache can be patched. Possible values
     include: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday",
     "Everyday", "Weekend".
    :type day_of_week: str or ~azure.mgmt.redis.models.DayOfWeek
    :param start_hour_utc: Required. Start hour after which cache patching can start.
    :type start_hour_utc: int
    :param maintenance_window: ISO8601 timespan specifying how much time cache patching can take.
    :type maintenance_window: ~datetime.timedelta
    """

    _validation = {
        'day_of_week': {'required': True},
        'start_hour_utc': {'required': True},
    }

    _attribute_map = {
        'day_of_week': {'key': 'dayOfWeek', 'type': 'str'},
        'start_hour_utc': {'key': 'startHourUtc', 'type': 'int'},
        'maintenance_window': {'key': 'maintenanceWindow', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduleEntry, self).__init__(**kwargs)
        self.day_of_week = kwargs['day_of_week']
        self.start_hour_utc = kwargs['start_hour_utc']
        self.maintenance_window = kwargs.get('maintenance_window', None)


class Sku(msrest.serialization.Model):
    """SKU parameters supplied to the create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The type of Redis cache to deploy. Valid values: (Basic, Standard,
     Premium). Possible values include: "Basic", "Standard", "Premium".
    :type name: str or ~azure.mgmt.redis.models.SkuName
    :param family: Required. The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P =
     Premium). Possible values include: "C", "P".
    :type family: str or ~azure.mgmt.redis.models.SkuFamily
    :param capacity: Required. The size of the Redis cache to deploy. Valid values: for C
     (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'family': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.family = kwargs['family']
        self.capacity = kwargs['capacity']


class UpgradeNotification(msrest.serialization.Model):
    """Properties of upgrade notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of upgrade notification.
    :vartype name: str
    :ivar timestamp: Timestamp when upgrade notification occurred.
    :vartype timestamp: ~datetime.datetime
    :ivar upsell_notification: Details about this upgrade notification.
    :vartype upsell_notification: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'timestamp': {'readonly': True},
        'upsell_notification': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'upsell_notification': {'key': 'upsellNotification', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeNotification, self).__init__(**kwargs)
        self.name = None
        self.timestamp = None
        self.upsell_notification = None
