#!/usr/bin/perl

#
# @BEGIN LICENSE
#
# Psi4: an open-source quantum chemistry software package
#
# Copyright (c) 2007-2019 The Psi4 Developers.
#
# The copyrights for code used from other parties are included in
# the corresponding files.
#
# This file is part of Psi4.
#
# Psi4 is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, version 3.
#
# Psi4 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with Psi4; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# @END LICENSE
#

use strict;
use warnings;
use File::Path qw(remove_tree);

my $DriverPath = "";
if ($#ARGV == 0) { $DriverPath = $ARGV[0] . "/"; }

#
# First, grab the license
#

my $LicenseFile = $DriverPath . "../../psi4/driver/source.template";
my $license = read_file($LicenseFile);

sub read_file {
    my ($filename) = @_;
 
    open my $in, '<:encoding(UTF-8)', $filename or die "Could not open '$filename' for reading $!";
    local $/ = undef;
    my $all = <$in>;
    close $in;
 
    return $all;
}

#
# Now, grab the physical constants
#
my $PhysconstFile = $DriverPath . "../../psi4/include/psi4/physconst.h";
my $PyPhysconstFile = $DriverPath . "../../psi4/driver/constants/physconst.py";
open(PHYSCONST, "<$PhysconstFile") or die "I can't open $PhysconstFile\n";
open(TEXOUT, ">physconst.tex") or die "I can't write to physconst.tex\n";
open(PYOUT, ">physconst.py") or die "I can't write to $PyPhysconstFile\n";
open(RSTOUT, ">source/autodoc_physconst.rst") or die "I can't write to physconst.rst\n";
print PYOUT "$license";
print PYOUT "# Do not modify this file! It is auto-generated by the document_options_and_tests\n".
            "# script, from psi4topdir/psi4/include/psi4/physconst.h\n";
printf RSTOUT ".. index:: physconst\n";
printf RSTOUT ".. _`apdx:physconst`:\n\n";
printf RSTOUT ".. _`table:physconst`:\n\n";
printf RSTOUT "Physical Constants\n";
printf RSTOUT "==================\n\n";
printf RSTOUT ".. table:: Physical constants in |PSIfour|\n\n";
printf RSTOUT "   +-%-60s-+-%-40s-+-%-100s-+\n", ('-' x 60), ('-' x 40), ('-' x 100);
printf RSTOUT "   | %-60s | %-40s | %-100s |\n", "Label", "Value", "Description";
printf RSTOUT "   +=%60s=+=%40s=+=%100s=+\n", ('=' x 60), ('=' x 40), ('=' x 100);
while(<PHYSCONST>){
    next unless /\s*#define\s+pc_(\w+)\s+([-+Ee0-9.]+)\s+\/\*-(.*)-\*\//;
    my $Var     = $1;
    my $Val     = $2;
    my $Comment = $3;
    printf PYOUT "%-25s = %-40s #%-40s\n", $Var, $Val, $Comment;
    printf RSTOUT "   | %60s | %-40s | %-100s |\n", $Var, $Val, $Comment;
    printf RSTOUT "   +-%-60s-+-%-40s-+-%-100s-+\n", ('-' x 60), ('-' x 40), ('-' x 100);
    $Var =~ s/_/\\_/g; # Make things TeX-friendly
    $Comment =~ s/_/\\_/g; # Make things TeX-friendly
    $Comment =~ s/@@/_/g;  # process @@ as math mode subscript in tex
    printf TEXOUT "psi%-25s & %-40s & %-40s\\\\\n", $Var, $Val, $Comment;
}
print "Auto-documenting constants file physconst.h\n";
close PHYSCONST;
close PYOUT;
unlink("physconst.py");
close TEXOUT;
unlink("physconst.tex");
printf RSTOUT "\n";
close RSTOUT;


