/* These are used both by PAPI and by the genpapifdef utility */

/* They are in their own include to allow genpapifdef to be built */
/* without having to link against libpapi.a                       */

hwi_presets_t _papi_hwi_presets[PAPI_MAX_PRESET_EVENTS] = {
/*  0 */ {"PAPI_L1_DCM", 
          "L1D cache misses", 
          "Level 1 data cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/*  1 */ {"PAPI_L1_ICM", 
	  "L1I cache misses", 
	  "Level 1 instruction cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/*  2 */ {"PAPI_L2_DCM", 
	  "L2D cache misses", 
	  "Level 2 data cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/*  3 */ {"PAPI_L2_ICM", 
          "L2I cache misses", 
          "Level 2 instruction cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/*  4 */ {"PAPI_L3_DCM", 
	  "L3D cache misses", 
	  "Level 3 data cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/*  5 */ {"PAPI_L3_ICM", 
	  "L3I cache misses", 
	  "Level 3 instruction cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/*  6 */ {"PAPI_L1_TCM", 
	  "L1 cache misses", 
	  "Level 1 cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/*  7 */ {"PAPI_L2_TCM", 
	  "L2 cache misses", 
	  "Level 2 cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/*  8 */ {"PAPI_L3_TCM", 
	  "L3 cache misses", 
	  "Level 3 cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/*  9 */ {"PAPI_CA_SNP", 
	  "Snoop Requests", 
	  "Requests for a snoop", 0,
	  0, PAPI_PRESET_BIT_CACH,
	  NULL, {0},{NULL}, NULL},
/* 10 */ {"PAPI_CA_SHR", 
	  "Ex Acces shared CL", 
	  "Requests for exclusive access to shared cache line", 0,
	  0, PAPI_PRESET_BIT_CACH,
	  NULL, {0},{NULL}, NULL},
/* 11 */ {"PAPI_CA_CLN", 
	  "Ex Access clean CL", 
	  "Requests for exclusive access to clean cache line", 0,
	  0, PAPI_PRESET_BIT_CACH,
	  NULL, {0},{NULL}, NULL},
/* 12 */ {"PAPI_CA_INV", 
          "Cache ln invalid",
	  "Requests for cache line invalidation", 0,
	  0, PAPI_PRESET_BIT_CACH,
	  NULL, {0},{NULL}, NULL},
/* 13 */ {"PAPI_CA_ITV", 
          "Cache ln intervene",
	  "Requests for cache line intervention", 0,
	  0, PAPI_PRESET_BIT_CACH,
	  NULL, {0},{NULL}, NULL},
/* 14 */ {"PAPI_L3_LDM", 
	  "L3 load misses", 
	  "Level 3 load misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 15 */ {"PAPI_L3_STM", 
	  "L3 store misses", 
	  "Level 3 store misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 16 */ {"PAPI_BRU_IDL", 
	  "Branch idle cycles",
	  "Cycles branch units are idle", 0,
	  0, PAPI_PRESET_BIT_IDL + PAPI_PRESET_BIT_BR,
	  NULL, {0},{NULL}, NULL},
/* 17 */ {"PAPI_FXU_IDL", 
	  "IU idle cycles",
	  "Cycles integer units are idle", 0,
	  0, PAPI_PRESET_BIT_IDL,
	  NULL, {0},{NULL}, NULL},
/* 18 */ {"PAPI_FPU_IDL", 
	  "FPU idle cycles",
	  "Cycles floating point units are idle", 0,
	  0, PAPI_PRESET_BIT_IDL + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 19 */ {"PAPI_LSU_IDL", 
	  "L/SU idle cycles",
	  "Cycles load/store units are idle", 0,
	  0, PAPI_PRESET_BIT_IDL + PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 20 */ {"PAPI_TLB_DM", 
	  "Data TLB misses",
	  "Data translation lookaside buffer misses", 0,
	  0, PAPI_PRESET_BIT_TLB,
	  NULL, {0},{NULL}, NULL},
/* 21 */ {"PAPI_TLB_IM", 
	  "Instr TLB misses",
	  "Instruction translation lookaside buffer misses", 0,
	  0, PAPI_PRESET_BIT_TLB + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 22 */ {"PAPI_TLB_TL",
	  "Total TLB misses",
	  "Total translation lookaside buffer misses", 0,
	  0, PAPI_PRESET_BIT_TLB,
	  NULL, {0},{NULL}, NULL},
/* 23 */ {"PAPI_L1_LDM",
	  "L1 load misses", 
	  "Level 1 load misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 24 */ {"PAPI_L1_STM", 
	  "L1 store misses", 
	  "Level 1 store misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 25 */ {"PAPI_L2_LDM", 
	  "L2 load misses", 
	  "Level 2 load misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 26 */ {"PAPI_L2_STM", 
	  "L2 store misses", 
	  "Level 2 store misses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 27 */ {"PAPI_BTAC_M", 
	  "Br targt addr miss",
	  "Branch target address cache misses", 0,
	  0, PAPI_PRESET_BIT_BR,
	  NULL, {0},{NULL}, NULL},
/* 28 */ {"PAPI_PRF_DM", 
	  "Data prefetch miss",
	  "Data prefetch cache misses", 0,
	  0, PAPI_PRESET_BIT_CACH,
	  NULL, {0},{NULL}, NULL},
/* 29 */ {"PAPI_L3_DCH", 
	  "L3D cache hits", 
	  "Level 3 data cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 30 */ {"PAPI_TLB_SD",
	  "TLB shootdowns",
	  "Translation lookaside buffer shootdowns", 0,
	  0, PAPI_PRESET_BIT_TLB,
	  NULL, {0},{NULL}, NULL},
/* 31 */ {"PAPI_CSR_FAL", 
	  "Failed store cond",
	  "Failed store conditional instructions", 0,
	  0, PAPI_PRESET_BIT_CND + PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 32 */ {"PAPI_CSR_SUC", 
	  "Good store cond",
	  "Successful store conditional instructions", 0,
	  0, PAPI_PRESET_BIT_CND + PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 33 */ {"PAPI_CSR_TOT", 
	  "Total store cond",
	  "Total store conditional instructions", 0,
	  0, PAPI_PRESET_BIT_CND + PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 34 */ {"PAPI_MEM_SCY", 
	  "Stalled mem cycles",
	  "Cycles Stalled Waiting for memory accesses", 0,
	  0, PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 35 */ {"PAPI_MEM_RCY", 
	  "Stalled rd cycles",
	  "Cycles Stalled Waiting for memory Reads", 0,
	  0, PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 36 */ {"PAPI_MEM_WCY", 
	  "Stalled wr cycles",
	  "Cycles Stalled Waiting for memory writes", 0,
	  0, PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 37 */ {"PAPI_STL_ICY", 
	  "No instr issue",
	  "Cycles with no instruction issue", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 38 */ {"PAPI_FUL_ICY", 
	  "Max instr issue",
	  "Cycles with maximum instruction issue", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 39 */ {"PAPI_STL_CCY", 
	  "No instr done",
	  "Cycles with no instructions completed", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 40 */ {"PAPI_FUL_CCY", 
	  "Max instr done",
	  "Cycles with maximum instructions completed", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 41 */ {"PAPI_HW_INT", 
	  "Hdw interrupts", 
	  "Hardware interrupts", 0,
	  0, PAPI_PRESET_BIT_MSC,
	  NULL, {0},{NULL}, NULL},
/* 42 */ {"PAPI_BR_UCN", 
	  "Uncond branch",
	  "Unconditional branch instructions", 0,
	  0, PAPI_PRESET_BIT_BR + PAPI_PRESET_BIT_CND,
	  NULL, {0},{NULL}, NULL},
/* 43 */ {"PAPI_BR_CN", 
	  "Cond branch", 
	  "Conditional branch instructions", 0,
	  0, PAPI_PRESET_BIT_BR + PAPI_PRESET_BIT_CND,
	  NULL, {0},{NULL}, NULL},
/* 44 */ {"PAPI_BR_TKN", 
	  "Cond branch taken",
	  "Conditional branch instructions taken", 0,
	  0, PAPI_PRESET_BIT_BR + PAPI_PRESET_BIT_CND,
	  NULL, {0},{NULL}, NULL},
/* 45 */ {"PAPI_BR_NTK", 
	  "Cond br not taken",
	  "Conditional branch instructions not taken", 0,
	  0, PAPI_PRESET_BIT_BR + PAPI_PRESET_BIT_CND,
	  NULL, {0},{NULL}, NULL},
/* 46 */ {"PAPI_BR_MSP", 
	  "Cond br mspredictd",
	  "Conditional branch instructions mispredicted", 0,
	  0, PAPI_PRESET_BIT_BR + PAPI_PRESET_BIT_CND,
	  NULL, {0},{NULL}, NULL},
/* 47 */ {"PAPI_BR_PRC", 
	  "Cond br predicted",
	  "Conditional branch instructions correctly predicted", 0,
	  0, PAPI_PRESET_BIT_BR + PAPI_PRESET_BIT_CND,
	  NULL, {0},{NULL}, NULL},
/* 48 */ {"PAPI_FMA_INS", 
	  "FMAs completed", 
	  "FMA instructions completed", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 49 */ {"PAPI_TOT_IIS", 
	  "Instr issued", 
	  "Instructions issued", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 50 */ {"PAPI_TOT_INS", 
	  "Instr completed", 
	  "Instructions completed", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 51 */ {"PAPI_INT_INS", 
	  "Int instructions", 
	  "Integer instructions", 0,
	  0, PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 52 */ {"PAPI_FP_INS", 
	  "FP instructions", 
	  "Floating point instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 53 */ {"PAPI_LD_INS", 
	  "Loads", 
	  "Load instructions", 0,
	  0, PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 54 */ {"PAPI_SR_INS", 
	  "Stores", 
	  "Store instructions", 0,
	  0, PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 55 */ {"PAPI_BR_INS", 
	  "Branches", 
	  "Branch instructions", 0,
	  0, PAPI_PRESET_BIT_BR,
	  NULL, {0},{NULL}, NULL},
/* 56 */ {"PAPI_VEC_INS", 
	  "Vector/SIMD instr",
	  "Vector/SIMD instructions (could include integer)", 0,
	  0, PAPI_PRESET_BIT_MSC,
	  NULL, {0},{NULL}, NULL},
/* 57 */ {"PAPI_RES_STL", 
	  "Stalled res cycles",
	  "Cycles stalled on any resource", 0,
	  0, PAPI_PRESET_BIT_IDL + PAPI_PRESET_BIT_MSC,
	  NULL, {0},{NULL}, NULL},
/* 58 */ {"PAPI_FP_STAL", 
	  "Stalled FPU cycles",
	  "Cycles the FP unit(s) are stalled", 0,
	  0, PAPI_PRESET_BIT_IDL + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 59 */ {"PAPI_TOT_CYC", 
	  "Total cycles", 
	  "Total cycles", 0,
	  0, PAPI_PRESET_BIT_MSC,
	  NULL, {0},{NULL}, NULL},
/* 60 */ {"PAPI_LST_INS", 
	  "L/S completed",
	  "Load/store instructions completed", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_MEM,
	  NULL, {0},{NULL}, NULL},
/* 61 */ {"PAPI_SYC_INS", 
	  "Syncs completed",
	  "Synchronization instructions completed", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_MSC,
	  NULL, {0},{NULL}, NULL},
/* 62 */ {"PAPI_L1_DCH", 
	  "L1D cache hits", 
	  "Level 1 data cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 63 */ {"PAPI_L2_DCH", 
	  "L2D cache hits", 
	  "Level 2 data cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 64 */ {"PAPI_L1_DCA", 
	  "L1D cache accesses",
	  "Level 1 data cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 65 */ {"PAPI_L2_DCA", 
	  "L2D cache accesses",
	  "Level 2 data cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 66 */ {"PAPI_L3_DCA", 
	  "L3D cache accesses",
	  "Level 3 data cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 67 */ {"PAPI_L1_DCR", 
	  "L1D cache reads", 
	  "Level 1 data cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 68 */ {"PAPI_L2_DCR", 
	  "L2D cache reads", 
	  "Level 2 data cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 69 */ {"PAPI_L3_DCR", 
	  "L3D cache reads", 
	  "Level 3 data cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 70 */ {"PAPI_L1_DCW", 
	  "L1D cache writes", 
	  "Level 1 data cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 71 */ {"PAPI_L2_DCW", 
	  "L2D cache writes", 
	  "Level 2 data cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 72 */ {"PAPI_L3_DCW", 
	  "L3D cache writes", 
	  "Level 3 data cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 73 */ {"PAPI_L1_ICH", 
	  "L1I cache hits",
	  "Level 1 instruction cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 74 */ {"PAPI_L2_ICH", 
	  "L2I cache hits",
	  "Level 2 instruction cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 75 */ {"PAPI_L3_ICH", 
	  "L3I cache hits",
	  "Level 3 instruction cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 76 */ {"PAPI_L1_ICA", 
	  "L1I cache accesses",
	  "Level 1 instruction cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 77 */ {"PAPI_L2_ICA", 
	  "L2I cache accesses",
	  "Level 2 instruction cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 78 */ {"PAPI_L3_ICA", 
	  "L3I cache accesses",
	  "Level 3 instruction cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 79 */ {"PAPI_L1_ICR", 
	  "L1I cache reads",
	  "Level 1 instruction cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 80 */ {"PAPI_L2_ICR", 
	  "L2I cache reads",
	  "Level 2 instruction cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 81 */ {"PAPI_L3_ICR", 
	  "L3I cache reads",
	  "Level 3 instruction cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 82 */ {"PAPI_L1_ICW", 
	  "L1I cache writes",
	  "Level 1 instruction cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 83 */ {"PAPI_L2_ICW", 
	  "L2I cache writes",
	  "Level 2 instruction cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 84 */ {"PAPI_L3_ICW", 
	  "L3I cache writes",
	  "Level 3 instruction cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3 + PAPI_PRESET_BIT_INS,
	  NULL, {0},{NULL}, NULL},
/* 85 */ {"PAPI_L1_TCH", 
	  "L1 cache hits", 
	  "Level 1 total cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 86 */ {"PAPI_L2_TCH", 
	  "L2 cache hits", 
	  "Level 2 total cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 87 */ {"PAPI_L3_TCH", 
	  "L3 cache hits", 
	  "Level 3 total cache hits", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 88 */ {"PAPI_L1_TCA", 
	  "L1 cache accesses",
	  "Level 1 total cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 89 */ {"PAPI_L2_TCA", 
	  "L2 cache accesses",
	  "Level 2 total cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 90 */ {"PAPI_L3_TCA", 
	  "L3 cache accesses",
	  "Level 3 total cache accesses", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 91 */ {"PAPI_L1_TCR", 
	  "L1 cache reads", 
	  "Level 1 total cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 92 */ {"PAPI_L2_TCR", 
	  "L2 cache reads", 
	  "Level 2 total cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 93 */ {"PAPI_L3_TCR", 
	  "L3 cache reads", 
	  "Level 3 total cache reads", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 94 */ {"PAPI_L1_TCW", 
	  "L1 cache writes", 
	  "Level 1 total cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L1,
	  NULL, {0},{NULL}, NULL},
/* 95 */ {"PAPI_L2_TCW", 
	  "L2 cache writes",
	  "Level 2 total cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L2,
	  NULL, {0},{NULL}, NULL},
/* 96 */ {"PAPI_L3_TCW", 
	  "L3 cache writes", 
	  "Level 3 total cache writes", 0,
	  0, PAPI_PRESET_BIT_CACH + PAPI_PRESET_BIT_L3,
	  NULL, {0},{NULL}, NULL},
/* 97 */ {"PAPI_FML_INS", 
	  "FPU multiply",
	  "Floating point multiply instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 98 */ {"PAPI_FAD_INS", 
	  "FPU add", 
	  "Floating point add instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 99 */ {"PAPI_FDV_INS", 
	  "FPU divide",
	  "Floating point divide instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/*100 */ {"PAPI_FSQ_INS", 
	  "FPU square root",
	  "Floating point square root instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/*101 */ {"PAPI_FNV_INS", 
	  "FPU inverse",
	  "Floating point inverse instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/*102 */ {"PAPI_FP_OPS", 
	  "FP operations", 
	  "Floating point operations", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/*103 */ {"PAPI_SP_OPS", 
	  "SP operations",
	  "Floating point operations; optimized to count scaled single precision vector operations", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/*104 */ {"PAPI_DP_OPS", 
	  "DP operations",
	  "Floating point operations; optimized to count scaled double precision vector operations", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/*105 */ {"PAPI_VEC_SP", 
	  "SP Vector/SIMD instr",
	  "Single precision vector/SIMD instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP, 
	  NULL, {0},{NULL}, NULL},
/*106 */ {"PAPI_VEC_DP", 
	  "DP Vector/SIMD instr",
	  "Double precision vector/SIMD instructions", 0,
	  0, PAPI_PRESET_BIT_INS + PAPI_PRESET_BIT_FP,
	  NULL, {0},{NULL}, NULL},
/* 107 */ {"PAPI_REF_CYC", 
	  "Reference cycles", 
	  "Reference clock cycles", 0,
	  0, PAPI_PRESET_BIT_MSC,
	  NULL, {0},{NULL}, NULL},
/*108 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*109 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*110 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*111 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*112 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*113 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*114 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*115 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*116 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*117 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*118 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*119 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*120 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*121 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*122 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*123 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*124 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*125 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*126 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
/*127 */ {NULL, NULL, NULL,0,0,0,NULL,{0},{NULL}, NULL},
};

#if 0
const hwi_describe_t _papi_hwi_err[PAPI_NUM_ERRORS] = {
    /* 0 */ {PAPI_OK, "PAPI_OK", "No error"},
    /* 1 */ {PAPI_EINVAL, "PAPI_EINVAL", "Invalid argument"},
    /* 2 */ {PAPI_ENOMEM, "PAPI_ENOMEM", "Insufficient memory"},
    /* 3 */ {PAPI_ESYS, "PAPI_ESYS", "A System/C library call failed"},
    /* 4 */ {PAPI_ECMP, "PAPI_ECMP", "Not supported by component"},
    /* 5 */ {PAPI_ECLOST, "PAPI_ECLOST", "Access to the counters was lost or interrupted"},
    /* 6 */ {PAPI_EBUG, "PAPI_EBUG", "Internal error, please send mail to the developers"},
    /* 7 */ {PAPI_ENOEVNT, "PAPI_ENOEVNT", "Event does not exist"},
    /* 8 */ {PAPI_ECNFLCT, "PAPI_ECNFLCT", "Event exists, but cannot be counted due to hardware resource limits"},
    /* 9 */ {PAPI_ENOTRUN, "PAPI_ENOTRUN", "EventSet is currently not running"},
    /*10 */ {PAPI_EISRUN, "PAPI_EISRUN", "EventSet is currently counting"},
    /*11 */ {PAPI_ENOEVST, "PAPI_ENOEVST", "No such EventSet available"},
    /*12 */ {PAPI_ENOTPRESET, "PAPI_ENOTPRESET", "Event in argument is not a valid preset"},
    /*13 */ {PAPI_ENOCNTR, "PAPI_ENOCNTR", "Hardware does not support performance counters"},
    /*14 */ {PAPI_EMISC, "PAPI_EMISC", "Unknown error code"},
    /*15 */ {PAPI_EPERM, "PAPI_EPERM", "Permission level does not permit operation"},
    /*16 */ {PAPI_ENOINIT, "PAPI_ENOINIT", "PAPI hasn't been initialized yet"},
    /*17 */ {PAPI_ENOCMP, "PAPI_ENOCMP", "Component Index isn't set"},
    /*18 */ {PAPI_ENOSUPP, "PAPI_ENOSUPP", "Not supported"},
    /*19 */ {PAPI_ENOIMPL, "PAPI_ENOIMPL", "Not implemented"},
    /*20 */ {PAPI_EBUF, "PAPI_EBUF", "Buffer size exceeded"},
    /*21 */ {PAPI_EINVAL_DOM, "PAPI_EINVAL_DOM", "EventSet domain is not supported for the operation"},
    /*22 */ {PAPI_EATTR, "PAPI_EATTR", "Invalid or missing event attributes"},
    /*23 */ {PAPI_ECOUNT, "PAPI_ECOUNT", "Too many events or attributes"},
    /*24 */ {PAPI_ECOMBO, "PAPI_ECOMBO", "Bad combination of features"}
    /*25 */ {PAPI_ECMP_DISABLED, "PAPI_ECMP_DISABLED", "Component containing event is disabled"}
};
#endif

