Migration to v4
===============

v4 has the same external API as v3, but significantly changed internals. Plugin
authors should update their packages.

## For users

External API did not change.

- If you used `markdown-it` with plugins - make sure to update those.
- If you modified renderer - see dev info below.
- If you did not use plugins and renderer modification - no changes needed.


## For developers

### Tokens and renderer

- [Tokens](https://github.com/markdown-it/markdown-it/blob/master/lib/token.js)
  are now classes, and allow arbitrary attributes.
  - new tokens are created with `token = state.push(type, tag, nesting)`.
    See [this commit](https://github.com/markdown-it/markdown-it/commit/4aabd5592ea55fb43d6a215b316c89c6f6f1f7db) to understand
    how to create tokens in new way. Also see changes in plugins from other
    repos in this org.
- [Renderer](https://github.com/markdown-it/markdown-it/blob/master/lib/renderer.js)
  methods were unified. Number of custom renderer rules were significantly reduced.
  Custom renderer functions need update due to tokens format change.

### Other changes

- `.validateUrl()` -> moved to root class `.validateLink()`
- added `.normalizeLink()` & `.normalizeLinkText()` to root class, and removed
  `normalizeUrl()` from utils.
- removed `replaceEntities()` in `utils`.
