/* GStreamer
 * Copyright (C) 2022 Seungha Yang <seungha@centricular.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/**
 * plugin-win32ipc:
 *
 * Windows IPC plugin
 *
 * Since: 1.22
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include "gstwin32ipcvideosink.h"
#include "gstwin32ipcvideosrc.h"
#include "gstwin32ipcsink.h"
#include "gstwin32ipcsrc.h"

GST_DEBUG_CATEGORY (gst_win32_ipc_debug);
#define GST_CAT_DEFAULT gst_win32_ipc_debug

static gboolean
plugin_init (GstPlugin * plugin)
{
  GST_DEBUG_CATEGORY_INIT (gst_win32_ipc_debug, "win32ipc", 0, "win32ipc");

  gst_element_register (plugin,
      "win32ipcvideosink", GST_RANK_NONE, GST_TYPE_WIN32_IPC_VIDEO_SINK);
  gst_element_register (plugin,
      "win32ipcvideosrc", GST_RANK_NONE, GST_TYPE_WIN32_IPC_VIDEO_SRC);
  gst_element_register (plugin,
      "win32ipcsink", GST_RANK_NONE, GST_TYPE_WIN32_IPC_SINK);
  gst_element_register (plugin,
      "win32ipcsrc", GST_RANK_NONE, GST_TYPE_WIN32_IPC_SRC);

  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    win32ipc,
    "Windows IPC plugin",
    plugin_init, VERSION, "LGPL", GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN)
