// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/storage/v2/storage.proto

package storage

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Predefined or "canned" aliases for sets of specific object ACL entries.
type PredefinedObjectAcl int32

const (
	// No predefined ACL.
	PredefinedObjectAcl_PREDEFINED_OBJECT_ACL_UNSPECIFIED PredefinedObjectAcl = 0
	// Object owner gets `OWNER` access, and
	// `allAuthenticatedUsers` get `READER` access.
	PredefinedObjectAcl_OBJECT_ACL_AUTHENTICATED_READ PredefinedObjectAcl = 1
	// Object owner gets `OWNER` access, and project team owners get
	// `OWNER` access.
	PredefinedObjectAcl_OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL PredefinedObjectAcl = 2
	// Object owner gets `OWNER` access, and project team owners get
	// `READER` access.
	PredefinedObjectAcl_OBJECT_ACL_BUCKET_OWNER_READ PredefinedObjectAcl = 3
	// Object owner gets `OWNER` access.
	PredefinedObjectAcl_OBJECT_ACL_PRIVATE PredefinedObjectAcl = 4
	// Object owner gets `OWNER` access, and project team members get
	// access according to their roles.
	PredefinedObjectAcl_OBJECT_ACL_PROJECT_PRIVATE PredefinedObjectAcl = 5
	// Object owner gets `OWNER` access, and `allUsers`
	// get `READER` access.
	PredefinedObjectAcl_OBJECT_ACL_PUBLIC_READ PredefinedObjectAcl = 6
)

// Enum value maps for PredefinedObjectAcl.
var (
	PredefinedObjectAcl_name = map[int32]string{
		0: "PREDEFINED_OBJECT_ACL_UNSPECIFIED",
		1: "OBJECT_ACL_AUTHENTICATED_READ",
		2: "OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL",
		3: "OBJECT_ACL_BUCKET_OWNER_READ",
		4: "OBJECT_ACL_PRIVATE",
		5: "OBJECT_ACL_PROJECT_PRIVATE",
		6: "OBJECT_ACL_PUBLIC_READ",
	}
	PredefinedObjectAcl_value = map[string]int32{
		"PREDEFINED_OBJECT_ACL_UNSPECIFIED":    0,
		"OBJECT_ACL_AUTHENTICATED_READ":        1,
		"OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL": 2,
		"OBJECT_ACL_BUCKET_OWNER_READ":         3,
		"OBJECT_ACL_PRIVATE":                   4,
		"OBJECT_ACL_PROJECT_PRIVATE":           5,
		"OBJECT_ACL_PUBLIC_READ":               6,
	}
)

func (x PredefinedObjectAcl) Enum() *PredefinedObjectAcl {
	p := new(PredefinedObjectAcl)
	*p = x
	return p
}

func (x PredefinedObjectAcl) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PredefinedObjectAcl) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v2_storage_proto_enumTypes[0].Descriptor()
}

func (PredefinedObjectAcl) Type() protoreflect.EnumType {
	return &file_google_storage_v2_storage_proto_enumTypes[0]
}

func (x PredefinedObjectAcl) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PredefinedObjectAcl.Descriptor instead.
func (PredefinedObjectAcl) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{0}
}

// A collection of constant values meaningful to the Storage API.
type ServiceConstants_Values int32

const (
	// Unused. Proto3 requires first enum to be 0.
	ServiceConstants_VALUES_UNSPECIFIED ServiceConstants_Values = 0
	// The maximum size chunk that can will be returned in a single
	// ReadRequest.
	// 2 MiB.
	ServiceConstants_MAX_READ_CHUNK_BYTES ServiceConstants_Values = 2097152
	// The maximum size chunk that can be sent in a single WriteObjectRequest.
	// 2 MiB.
	ServiceConstants_MAX_WRITE_CHUNK_BYTES ServiceConstants_Values = 2097152
	// The maximum size of an object in MB - whether written in a single stream
	// or composed from multiple other objects.
	// 5 TiB.
	ServiceConstants_MAX_OBJECT_SIZE_MB ServiceConstants_Values = 5242880
	// The maximum length field name that can be sent in a single
	// custom metadata field.
	// 1 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_FIELD_NAME_BYTES ServiceConstants_Values = 1024
	// The maximum length field value that can be sent in a single
	// custom_metadata field.
	// 4 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES ServiceConstants_Values = 4096
	// The maximum total bytes that can be populated into all field names and
	// values of the custom_metadata for one object.
	// 8 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES ServiceConstants_Values = 8192
	// The maximum total bytes that can be populated into all bucket metadata
	// fields.
	// 20 KiB.
	ServiceConstants_MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES ServiceConstants_Values = 20480
	// The maximum number of NotificationConfigs that can be registered
	// for a given bucket.
	ServiceConstants_MAX_NOTIFICATION_CONFIGS_PER_BUCKET ServiceConstants_Values = 100
	// The maximum number of LifecycleRules that can be registered for a given
	// bucket.
	ServiceConstants_MAX_LIFECYCLE_RULES_PER_BUCKET ServiceConstants_Values = 100
	// The maximum number of custom attributes per NotificationConfigs.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTES ServiceConstants_Values = 5
	// The maximum length of a custom attribute key included in
	// NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH ServiceConstants_Values = 256
	// The maximum length of a custom attribute value included in a
	// NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH ServiceConstants_Values = 1024
	// The maximum number of key/value entries per bucket label.
	ServiceConstants_MAX_LABELS_ENTRIES_COUNT ServiceConstants_Values = 64
	// The maximum character length of the key or value in a bucket
	// label map.
	ServiceConstants_MAX_LABELS_KEY_VALUE_LENGTH ServiceConstants_Values = 63
	// The maximum byte size of the key or value in a bucket label
	// map.
	ServiceConstants_MAX_LABELS_KEY_VALUE_BYTES ServiceConstants_Values = 128
	// The maximum number of object IDs that can be included in a
	// DeleteObjectsRequest.
	ServiceConstants_MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST ServiceConstants_Values = 1000
	// The maximum number of days for which a token returned by the
	// GetListObjectsSplitPoints RPC is valid.
	ServiceConstants_SPLIT_TOKEN_MAX_VALID_DAYS ServiceConstants_Values = 14
)

// Enum value maps for ServiceConstants_Values.
var (
	ServiceConstants_Values_name = map[int32]string{
		0:       "VALUES_UNSPECIFIED",
		2097152: "MAX_READ_CHUNK_BYTES",
		// Duplicate value: 2097152: "MAX_WRITE_CHUNK_BYTES",
		5242880: "MAX_OBJECT_SIZE_MB",
		1024:    "MAX_CUSTOM_METADATA_FIELD_NAME_BYTES",
		4096:    "MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES",
		8192:    "MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES",
		20480:   "MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES",
		100:     "MAX_NOTIFICATION_CONFIGS_PER_BUCKET",
		// Duplicate value: 100: "MAX_LIFECYCLE_RULES_PER_BUCKET",
		5:   "MAX_NOTIFICATION_CUSTOM_ATTRIBUTES",
		256: "MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH",
		// Duplicate value: 1024: "MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH",
		64:   "MAX_LABELS_ENTRIES_COUNT",
		63:   "MAX_LABELS_KEY_VALUE_LENGTH",
		128:  "MAX_LABELS_KEY_VALUE_BYTES",
		1000: "MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST",
		14:   "SPLIT_TOKEN_MAX_VALID_DAYS",
	}
	ServiceConstants_Values_value = map[string]int32{
		"VALUES_UNSPECIFIED":                             0,
		"MAX_READ_CHUNK_BYTES":                           2097152,
		"MAX_WRITE_CHUNK_BYTES":                          2097152,
		"MAX_OBJECT_SIZE_MB":                             5242880,
		"MAX_CUSTOM_METADATA_FIELD_NAME_BYTES":           1024,
		"MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES":          4096,
		"MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES":           8192,
		"MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES":           20480,
		"MAX_NOTIFICATION_CONFIGS_PER_BUCKET":            100,
		"MAX_LIFECYCLE_RULES_PER_BUCKET":                 100,
		"MAX_NOTIFICATION_CUSTOM_ATTRIBUTES":             5,
		"MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH":   256,
		"MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH": 1024,
		"MAX_LABELS_ENTRIES_COUNT":                       64,
		"MAX_LABELS_KEY_VALUE_LENGTH":                    63,
		"MAX_LABELS_KEY_VALUE_BYTES":                     128,
		"MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST":      1000,
		"SPLIT_TOKEN_MAX_VALID_DAYS":                     14,
	}
)

func (x ServiceConstants_Values) Enum() *ServiceConstants_Values {
	p := new(ServiceConstants_Values)
	*p = x
	return p
}

func (x ServiceConstants_Values) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConstants_Values) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v2_storage_proto_enumTypes[1].Descriptor()
}

func (ServiceConstants_Values) Type() protoreflect.EnumType {
	return &file_google_storage_v2_storage_proto_enumTypes[1]
}

func (x ServiceConstants_Values) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConstants_Values.Descriptor instead.
func (ServiceConstants_Values) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{11, 0}
}

// Public Access Prevention config values.
type Bucket_IamConfig_PublicAccessPrevention int32

const (
	// Does not prevent access from being granted to public members 'allUsers'
	// or 'allAuthenticatedUsers'. This setting may be enforced by Org Policy
	// at the project/folder/organization level.
	Bucket_IamConfig_PUBLIC_ACCESS_PREVENTION_UNSPECIFIED Bucket_IamConfig_PublicAccessPrevention = 0
	// Prevents access from being granted to public members 'allUsers' and
	// 'allAuthenticatedUsers'. Prevents attempts to grant new access to
	// public members.
	Bucket_IamConfig_ENFORCED Bucket_IamConfig_PublicAccessPrevention = 1
)

// Enum value maps for Bucket_IamConfig_PublicAccessPrevention.
var (
	Bucket_IamConfig_PublicAccessPrevention_name = map[int32]string{
		0: "PUBLIC_ACCESS_PREVENTION_UNSPECIFIED",
		1: "ENFORCED",
	}
	Bucket_IamConfig_PublicAccessPrevention_value = map[string]int32{
		"PUBLIC_ACCESS_PREVENTION_UNSPECIFIED": 0,
		"ENFORCED":                             1,
	}
)

func (x Bucket_IamConfig_PublicAccessPrevention) Enum() *Bucket_IamConfig_PublicAccessPrevention {
	p := new(Bucket_IamConfig_PublicAccessPrevention)
	*p = x
	return p
}

func (x Bucket_IamConfig_PublicAccessPrevention) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Bucket_IamConfig_PublicAccessPrevention) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v2_storage_proto_enumTypes[2].Descriptor()
}

func (Bucket_IamConfig_PublicAccessPrevention) Type() protoreflect.EnumType {
	return &file_google_storage_v2_storage_proto_enumTypes[2]
}

func (x Bucket_IamConfig_PublicAccessPrevention) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Bucket_IamConfig_PublicAccessPrevention.Descriptor instead.
func (Bucket_IamConfig_PublicAccessPrevention) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 3, 0}
}

// Request message for ReadObject.
type ReadObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the bucket containing the object to read.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The name of the object to read.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed
	// to the latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// The offset for the first byte to return in the read, relative to the start
	// of the object.
	//
	// A negative `read_offset` value will be interpreted as the number of bytes
	// back from the end of the object to be returned. For example, if an object's
	// length is 15 bytes, a ReadObjectRequest with `read_offset` = -5 and
	// `read_limit` = 3 would return bytes 10 through 12 of the object. Requesting
	// a negative offset whose magnitude is larger than the size of the object
	// will result in an error.
	ReadOffset int64 `protobuf:"varint,4,opt,name=read_offset,json=readOffset,proto3" json:"read_offset,omitempty"`
	// The maximum number of `data` bytes the server is allowed to return in the
	// sum of all `Object` messages. A `read_limit` of zero indicates that there
	// is no limit, and a negative `read_limit` will cause an error.
	//
	// If the stream returns fewer bytes than allowed by the `read_limit` and no
	// error occurred, the stream includes all data from the `read_offset` to the
	// end of the resource.
	ReadLimit int64 `protobuf:"varint,5,opt,name=read_limit,json=readLimit,proto3" json:"read_limit,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *int64 `protobuf:"varint,6,opt,name=if_generation_match,json=ifGenerationMatch,proto3,oneof" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *int64 `protobuf:"varint,7,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3,oneof" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *int64 `protobuf:"varint,8,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,9,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,10,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	// Mask specifying which fields to read.
	// The checksummed_data field and its children will always be present.
	// If no mask is specified, will default to all fields except metadata.owner
	// and metadata.acl.
	// * may be used to mean "all fields".
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,12,opt,name=read_mask,json=readMask,proto3,oneof" json:"read_mask,omitempty"`
}

func (x *ReadObjectRequest) Reset() {
	*x = ReadObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadObjectRequest) ProtoMessage() {}

func (x *ReadObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadObjectRequest.ProtoReflect.Descriptor instead.
func (*ReadObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{0}
}

func (x *ReadObjectRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ReadObjectRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *ReadObjectRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *ReadObjectRequest) GetReadOffset() int64 {
	if x != nil {
		return x.ReadOffset
	}
	return 0
}

func (x *ReadObjectRequest) GetReadLimit() int64 {
	if x != nil {
		return x.ReadLimit
	}
	return 0
}

func (x *ReadObjectRequest) GetIfGenerationMatch() int64 {
	if x != nil && x.IfGenerationMatch != nil {
		return *x.IfGenerationMatch
	}
	return 0
}

func (x *ReadObjectRequest) GetIfGenerationNotMatch() int64 {
	if x != nil && x.IfGenerationNotMatch != nil {
		return *x.IfGenerationNotMatch
	}
	return 0
}

func (x *ReadObjectRequest) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *ReadObjectRequest) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

func (x *ReadObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *ReadObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

func (x *ReadObjectRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for GetObject.
type ReadObjectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A portion of the data for the object. The service **may** leave `data`
	// empty for any given `ReadResponse`. This enables the service to inform the
	// client that the request is still live while it is running an operation to
	// generate more data.
	ChecksummedData *ChecksummedData `protobuf:"bytes,1,opt,name=checksummed_data,json=checksummedData,proto3" json:"checksummed_data,omitempty"`
	// The checksums of the complete object. The client should compute one of
	// these checksums over the downloaded object and compare it against the value
	// provided here.
	ObjectChecksums *ObjectChecksums `protobuf:"bytes,2,opt,name=object_checksums,json=objectChecksums,proto3" json:"object_checksums,omitempty"`
	// If read_offset and or read_limit was specified on the
	// ReadObjectRequest, ContentRange will be populated on the first
	// ReadObjectResponse message of the read stream.
	ContentRange *ContentRange `protobuf:"bytes,3,opt,name=content_range,json=contentRange,proto3" json:"content_range,omitempty"`
	// Metadata of the object whose media is being returned.
	// Only populated in the first response in the stream.
	Metadata *Object `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ReadObjectResponse) Reset() {
	*x = ReadObjectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadObjectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadObjectResponse) ProtoMessage() {}

func (x *ReadObjectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadObjectResponse.ProtoReflect.Descriptor instead.
func (*ReadObjectResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{1}
}

func (x *ReadObjectResponse) GetChecksummedData() *ChecksummedData {
	if x != nil {
		return x.ChecksummedData
	}
	return nil
}

func (x *ReadObjectResponse) GetObjectChecksums() *ObjectChecksums {
	if x != nil {
		return x.ObjectChecksums
	}
	return nil
}

func (x *ReadObjectResponse) GetContentRange() *ContentRange {
	if x != nil {
		return x.ContentRange
	}
	return nil
}

func (x *ReadObjectResponse) GetMetadata() *Object {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Describes an attempt to insert an object, possibly over multiple requests.
type WriteObjectSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Destination object, including its name and its metadata.
	Resource *Object `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl PredefinedObjectAcl `protobuf:"varint,2,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v2.PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Makes the operation conditional on whether the object's current
	// generation matches the given value. Setting to 0 makes the operation
	// succeed only if there are no live versions of the object.
	IfGenerationMatch *int64 `protobuf:"varint,3,opt,name=if_generation_match,json=ifGenerationMatch,proto3,oneof" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// generation does not match the given value. If no live object exists, the
	// precondition fails. Setting to 0 makes the operation succeed only if
	// there is a live version of the object.
	IfGenerationNotMatch *int64 `protobuf:"varint,4,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3,oneof" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *int64 `protobuf:"varint,5,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,6,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
}

func (x *WriteObjectSpec) Reset() {
	*x = WriteObjectSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteObjectSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteObjectSpec) ProtoMessage() {}

func (x *WriteObjectSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteObjectSpec.ProtoReflect.Descriptor instead.
func (*WriteObjectSpec) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{2}
}

func (x *WriteObjectSpec) GetResource() *Object {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *WriteObjectSpec) GetPredefinedAcl() PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return PredefinedObjectAcl_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *WriteObjectSpec) GetIfGenerationMatch() int64 {
	if x != nil && x.IfGenerationMatch != nil {
		return *x.IfGenerationMatch
	}
	return 0
}

func (x *WriteObjectSpec) GetIfGenerationNotMatch() int64 {
	if x != nil && x.IfGenerationNotMatch != nil {
		return *x.IfGenerationNotMatch
	}
	return 0
}

func (x *WriteObjectSpec) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *WriteObjectSpec) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

// Request message for WriteObject.
type WriteObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The first message of each stream should set one of the following.
	//
	// Types that are assignable to FirstMessage:
	//	*WriteObjectRequest_UploadId
	//	*WriteObjectRequest_WriteObjectSpec
	FirstMessage isWriteObjectRequest_FirstMessage `protobuf_oneof:"first_message"`
	// Required. The offset from the beginning of the object at which the data should be
	// written.
	//
	// In the first `WriteObjectRequest` of a `WriteObject()` action, it
	// indicates the initial offset for the `Write()` call. The value **must** be
	// equal to the `committed_size` that a call to `QueryWriteStatus()` would
	// return (0 if this is the first write to the object).
	//
	// On subsequent calls, this value **must** be no larger than the sum of the
	// first `write_offset` and the sizes of all `data` chunks sent previously on
	// this stream.
	//
	// An incorrect value will cause an error.
	WriteOffset int64 `protobuf:"varint,3,opt,name=write_offset,json=writeOffset,proto3" json:"write_offset,omitempty"`
	// A portion of the data for the object.
	//
	// Types that are assignable to Data:
	//	*WriteObjectRequest_ChecksummedData
	Data isWriteObjectRequest_Data `protobuf_oneof:"data"`
	// Checksums for the complete object. If the checksums computed by the service
	// don't match the specifified checksums the call will fail. May only be
	// provided in the first or last request (either with first_message, or
	// finish_write set).
	ObjectChecksums *ObjectChecksums `protobuf:"bytes,6,opt,name=object_checksums,json=objectChecksums,proto3" json:"object_checksums,omitempty"`
	// If `true`, this indicates that the write is complete. Sending any
	// `WriteObjectRequest`s subsequent to one in which `finish_write` is `true`
	// will cause an error.
	// For a non-resumable write (where the upload_id was not set in the first
	// message), it is an error not to set this field in the final message of the
	// stream.
	FinishWrite bool `protobuf:"varint,7,opt,name=finish_write,json=finishWrite,proto3" json:"finish_write,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,8,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,9,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *WriteObjectRequest) Reset() {
	*x = WriteObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteObjectRequest) ProtoMessage() {}

func (x *WriteObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteObjectRequest.ProtoReflect.Descriptor instead.
func (*WriteObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{3}
}

func (m *WriteObjectRequest) GetFirstMessage() isWriteObjectRequest_FirstMessage {
	if m != nil {
		return m.FirstMessage
	}
	return nil
}

func (x *WriteObjectRequest) GetUploadId() string {
	if x, ok := x.GetFirstMessage().(*WriteObjectRequest_UploadId); ok {
		return x.UploadId
	}
	return ""
}

func (x *WriteObjectRequest) GetWriteObjectSpec() *WriteObjectSpec {
	if x, ok := x.GetFirstMessage().(*WriteObjectRequest_WriteObjectSpec); ok {
		return x.WriteObjectSpec
	}
	return nil
}

func (x *WriteObjectRequest) GetWriteOffset() int64 {
	if x != nil {
		return x.WriteOffset
	}
	return 0
}

func (m *WriteObjectRequest) GetData() isWriteObjectRequest_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *WriteObjectRequest) GetChecksummedData() *ChecksummedData {
	if x, ok := x.GetData().(*WriteObjectRequest_ChecksummedData); ok {
		return x.ChecksummedData
	}
	return nil
}

func (x *WriteObjectRequest) GetObjectChecksums() *ObjectChecksums {
	if x != nil {
		return x.ObjectChecksums
	}
	return nil
}

func (x *WriteObjectRequest) GetFinishWrite() bool {
	if x != nil {
		return x.FinishWrite
	}
	return false
}

func (x *WriteObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *WriteObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

type isWriteObjectRequest_FirstMessage interface {
	isWriteObjectRequest_FirstMessage()
}

type WriteObjectRequest_UploadId struct {
	// For resumable uploads. This should be the `upload_id` returned from a
	// call to `StartResumableWriteResponse`.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3,oneof"`
}

type WriteObjectRequest_WriteObjectSpec struct {
	// For non-resumable uploads. Describes the overall upload, including the
	// destination bucket and object name, preconditions, etc.
	WriteObjectSpec *WriteObjectSpec `protobuf:"bytes,2,opt,name=write_object_spec,json=writeObjectSpec,proto3,oneof"`
}

func (*WriteObjectRequest_UploadId) isWriteObjectRequest_FirstMessage() {}

func (*WriteObjectRequest_WriteObjectSpec) isWriteObjectRequest_FirstMessage() {}

type isWriteObjectRequest_Data interface {
	isWriteObjectRequest_Data()
}

type WriteObjectRequest_ChecksummedData struct {
	// The data to insert. If a crc32c checksum is provided that doesn't match
	// the checksum computed by the service, the request will fail.
	ChecksummedData *ChecksummedData `protobuf:"bytes,4,opt,name=checksummed_data,json=checksummedData,proto3,oneof"`
}

func (*WriteObjectRequest_ChecksummedData) isWriteObjectRequest_Data() {}

// Response message for WriteObject.
type WriteObjectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response will set one of the following.
	//
	// Types that are assignable to WriteStatus:
	//	*WriteObjectResponse_CommittedSize
	//	*WriteObjectResponse_Resource
	WriteStatus isWriteObjectResponse_WriteStatus `protobuf_oneof:"write_status"`
}

func (x *WriteObjectResponse) Reset() {
	*x = WriteObjectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteObjectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteObjectResponse) ProtoMessage() {}

func (x *WriteObjectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteObjectResponse.ProtoReflect.Descriptor instead.
func (*WriteObjectResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{4}
}

func (m *WriteObjectResponse) GetWriteStatus() isWriteObjectResponse_WriteStatus {
	if m != nil {
		return m.WriteStatus
	}
	return nil
}

func (x *WriteObjectResponse) GetCommittedSize() int64 {
	if x, ok := x.GetWriteStatus().(*WriteObjectResponse_CommittedSize); ok {
		return x.CommittedSize
	}
	return 0
}

func (x *WriteObjectResponse) GetResource() *Object {
	if x, ok := x.GetWriteStatus().(*WriteObjectResponse_Resource); ok {
		return x.Resource
	}
	return nil
}

type isWriteObjectResponse_WriteStatus interface {
	isWriteObjectResponse_WriteStatus()
}

type WriteObjectResponse_CommittedSize struct {
	// The total number of bytes that have been processed for the given object
	// from all `WriteObject` calls. Only set if the upload has not finalized.
	CommittedSize int64 `protobuf:"varint,1,opt,name=committed_size,json=committedSize,proto3,oneof"`
}

type WriteObjectResponse_Resource struct {
	// A resource containing the metadata for the uploaded object. Only set if
	// the upload has finalized.
	Resource *Object `protobuf:"bytes,2,opt,name=resource,proto3,oneof"`
}

func (*WriteObjectResponse_CommittedSize) isWriteObjectResponse_WriteStatus() {}

func (*WriteObjectResponse_Resource) isWriteObjectResponse_WriteStatus() {}

// Request object for `QueryWriteStatus`.
type QueryWriteStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resume token for the object whose write status is being
	// requested.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,2,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *QueryWriteStatusRequest) Reset() {
	*x = QueryWriteStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWriteStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWriteStatusRequest) ProtoMessage() {}

func (x *QueryWriteStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWriteStatusRequest.ProtoReflect.Descriptor instead.
func (*QueryWriteStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{5}
}

func (x *QueryWriteStatusRequest) GetUploadId() string {
	if x != nil {
		return x.UploadId
	}
	return ""
}

func (x *QueryWriteStatusRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *QueryWriteStatusRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Response object for `QueryWriteStatus`.
type QueryWriteStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response will set one of the following.
	//
	// Types that are assignable to WriteStatus:
	//	*QueryWriteStatusResponse_CommittedSize
	//	*QueryWriteStatusResponse_Resource
	WriteStatus isQueryWriteStatusResponse_WriteStatus `protobuf_oneof:"write_status"`
}

func (x *QueryWriteStatusResponse) Reset() {
	*x = QueryWriteStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWriteStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWriteStatusResponse) ProtoMessage() {}

func (x *QueryWriteStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWriteStatusResponse.ProtoReflect.Descriptor instead.
func (*QueryWriteStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{6}
}

func (m *QueryWriteStatusResponse) GetWriteStatus() isQueryWriteStatusResponse_WriteStatus {
	if m != nil {
		return m.WriteStatus
	}
	return nil
}

func (x *QueryWriteStatusResponse) GetCommittedSize() int64 {
	if x, ok := x.GetWriteStatus().(*QueryWriteStatusResponse_CommittedSize); ok {
		return x.CommittedSize
	}
	return 0
}

func (x *QueryWriteStatusResponse) GetResource() *Object {
	if x, ok := x.GetWriteStatus().(*QueryWriteStatusResponse_Resource); ok {
		return x.Resource
	}
	return nil
}

type isQueryWriteStatusResponse_WriteStatus interface {
	isQueryWriteStatusResponse_WriteStatus()
}

type QueryWriteStatusResponse_CommittedSize struct {
	// The total number of bytes that have been processed for the given object
	// from all `WriteObject` calls. This is the correct value for the
	// 'write_offset' field to use when resuming the `WriteObject` operation.
	// Only set if the upload has not finalized.
	CommittedSize int64 `protobuf:"varint,1,opt,name=committed_size,json=committedSize,proto3,oneof"`
}

type QueryWriteStatusResponse_Resource struct {
	// A resource containing the metadata for the uploaded object. Only set if
	// the upload has finalized.
	Resource *Object `protobuf:"bytes,2,opt,name=resource,proto3,oneof"`
}

func (*QueryWriteStatusResponse_CommittedSize) isQueryWriteStatusResponse_WriteStatus() {}

func (*QueryWriteStatusResponse_Resource) isQueryWriteStatusResponse_WriteStatus() {}

// Request message StartResumableWrite.
type StartResumableWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination bucket, object, and metadata, as well as any preconditions.
	WriteObjectSpec *WriteObjectSpec `protobuf:"bytes,1,opt,name=write_object_spec,json=writeObjectSpec,proto3" json:"write_object_spec,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,3,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *StartResumableWriteRequest) Reset() {
	*x = StartResumableWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartResumableWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartResumableWriteRequest) ProtoMessage() {}

func (x *StartResumableWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartResumableWriteRequest.ProtoReflect.Descriptor instead.
func (*StartResumableWriteRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{7}
}

func (x *StartResumableWriteRequest) GetWriteObjectSpec() *WriteObjectSpec {
	if x != nil {
		return x.WriteObjectSpec
	}
	return nil
}

func (x *StartResumableWriteRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *StartResumableWriteRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Response object for `StartResumableWrite`.
type StartResumableWriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The upload_id of the newly started resumable write operation. This
	// value should be copied into the `WriteObjectRequest.upload_id` field.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
}

func (x *StartResumableWriteResponse) Reset() {
	*x = StartResumableWriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartResumableWriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartResumableWriteResponse) ProtoMessage() {}

func (x *StartResumableWriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartResumableWriteResponse.ProtoReflect.Descriptor instead.
func (*StartResumableWriteResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{8}
}

func (x *StartResumableWriteResponse) GetUploadId() string {
	if x != nil {
		return x.UploadId
	}
	return ""
}

// Parameters that can be passed to any object request.
type CommonObjectRequestParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Encryption algorithm used with Customer-Supplied Encryption Keys feature.
	EncryptionAlgorithm string `protobuf:"bytes,1,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	// Encryption key used with Customer-Supplied Encryption Keys feature.
	EncryptionKey string `protobuf:"bytes,2,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// SHA256 hash of encryption key used with Customer-Supplied Encryption Keys
	// feature.
	EncryptionKeySha256 string `protobuf:"bytes,3,opt,name=encryption_key_sha256,json=encryptionKeySha256,proto3" json:"encryption_key_sha256,omitempty"`
}

func (x *CommonObjectRequestParams) Reset() {
	*x = CommonObjectRequestParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonObjectRequestParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonObjectRequestParams) ProtoMessage() {}

func (x *CommonObjectRequestParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonObjectRequestParams.ProtoReflect.Descriptor instead.
func (*CommonObjectRequestParams) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{9}
}

func (x *CommonObjectRequestParams) GetEncryptionAlgorithm() string {
	if x != nil {
		return x.EncryptionAlgorithm
	}
	return ""
}

func (x *CommonObjectRequestParams) GetEncryptionKey() string {
	if x != nil {
		return x.EncryptionKey
	}
	return ""
}

func (x *CommonObjectRequestParams) GetEncryptionKeySha256() string {
	if x != nil {
		return x.EncryptionKeySha256
	}
	return ""
}

// Parameters that can be passed to any request.
type CommonRequestParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Required when using buckets with Requestor Pays feature enabled.
	// Example: `projects/123456`.
	UserProject string `protobuf:"bytes,1,opt,name=user_project,json=userProject,proto3" json:"user_project,omitempty"`
}

func (x *CommonRequestParams) Reset() {
	*x = CommonRequestParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonRequestParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonRequestParams) ProtoMessage() {}

func (x *CommonRequestParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonRequestParams.ProtoReflect.Descriptor instead.
func (*CommonRequestParams) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{10}
}

func (x *CommonRequestParams) GetUserProject() string {
	if x != nil {
		return x.UserProject
	}
	return ""
}

// Shared constants.
type ServiceConstants struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ServiceConstants) Reset() {
	*x = ServiceConstants{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConstants) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConstants) ProtoMessage() {}

func (x *ServiceConstants) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConstants.ProtoReflect.Descriptor instead.
func (*ServiceConstants) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{11}
}

// A bucket.
type Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the bucket.
	// Global buckets will be of the format `projects/{project}/buckets/{bucket}`.
	// Other sorts of buckets in the future are not guaranteed to follow this
	// pattern.
	// For globally unique bucket names, a `_` may be substituted for the project
	// ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
	// `name` field. For globally unique buckets, this is equal to the "bucket
	// name" of other Cloud Storage APIs. Example: "pub".
	BucketId string `protobuf:"bytes,2,opt,name=bucket_id,json=bucketId,proto3" json:"bucket_id,omitempty"`
	// Immutable. The project which owns this bucket.
	// Format: projects/{project_number}
	// Example: `projects/123456`.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. The metadata generation of this bucket.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	Metageneration int64 `protobuf:"varint,4,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// Immutable. The location of the bucket. Object data for objects in the bucket resides
	// in physical storage within this region.  Defaults to `US`. See the
	// [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
	// guide] for the authoritative list. Attempting to update this field after
	// the bucket is created will result in an error.
	Location string `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. The location type of the bucket (region, dual-region, multi-region, etc).
	LocationType string `protobuf:"bytes,6,opt,name=location_type,json=locationType,proto3" json:"location_type,omitempty"`
	// The bucket's default storage class, used whenever no storageClass is
	// specified for a newly-created object. This defines how objects in the
	// bucket are stored and determines the SLA and the cost of storage.
	// If this value is not specified when the bucket is created, it will default
	// to `STANDARD`. For more information, see
	// https://developers.google.com/storage/docs/storage-classes.
	StorageClass string `protobuf:"bytes,7,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Access controls on the bucket.
	// If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
	// requests to set, read, or modify acl is an error.
	Acl []*BucketAccessControl `protobuf:"bytes,8,rep,name=acl,proto3" json:"acl,omitempty"`
	// Default access controls to apply to new objects when no ACL is provided.
	// If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
	// requests to set, read, or modify acl is an error.
	DefaultObjectAcl []*ObjectAccessControl `protobuf:"bytes,9,rep,name=default_object_acl,json=defaultObjectAcl,proto3" json:"default_object_acl,omitempty"`
	// The bucket's lifecycle config. See
	// [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
	// for more information.
	Lifecycle *Bucket_Lifecycle `protobuf:"bytes,10,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Output only. The creation time of the bucket in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
	// (CORS) config.
	Cors []*Bucket_Cors `protobuf:"bytes,12,rep,name=cors,proto3" json:"cors,omitempty"`
	// Output only. The modification time of the bucket.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The default value for event-based hold on newly created objects in this
	// bucket.  Event-based hold is a way to retain objects indefinitely until an
	// event occurs, signified by the
	// hold's release. After being released, such objects will be subject to
	// bucket-level retention (if any).  One sample use case of this flag is for
	// banks to hold loan documents for at least 3 years after loan is paid in
	// full. Here, bucket-level retention is 3 years and the event is loan being
	// paid in full. In this example, these objects will be held intact for any
	// number of years until the event has occurred (event-based hold on the
	// object is released) and then 3 more years after that. That means retention
	// duration of the objects begins from the moment event-based hold
	// transitioned from true to false.  Objects under event-based hold cannot be
	// deleted, overwritten or archived until the hold is removed.
	DefaultEventBasedHold bool `protobuf:"varint,14,opt,name=default_event_based_hold,json=defaultEventBasedHold,proto3" json:"default_event_based_hold,omitempty"`
	// User-provided labels, in key/value pairs.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The bucket's website config, controlling how the service behaves
	// when accessing bucket contents as a web site. See the
	// [https://cloud.google.com/storage/docs/static-website][Static Website
	// Examples] for more information.
	Website *Bucket_Website `protobuf:"bytes,16,opt,name=website,proto3" json:"website,omitempty"`
	// The bucket's versioning config.
	Versioning *Bucket_Versioning `protobuf:"bytes,17,opt,name=versioning,proto3" json:"versioning,omitempty"`
	// The bucket's logging config, which defines the destination bucket
	// and name prefix (if any) for the current bucket's logs.
	Logging *Bucket_Logging `protobuf:"bytes,18,opt,name=logging,proto3" json:"logging,omitempty"`
	// Output only. The owner of the bucket. This is always the project team's owner group.
	Owner *Owner `protobuf:"bytes,19,opt,name=owner,proto3" json:"owner,omitempty"`
	// Encryption config for a bucket.
	Encryption *Bucket_Encryption `protobuf:"bytes,20,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// The bucket's billing config.
	Billing *Bucket_Billing `protobuf:"bytes,21,opt,name=billing,proto3" json:"billing,omitempty"`
	// The bucket's retention policy. The retention policy enforces a minimum
	// retention time for all objects contained in the bucket, based on their
	// creation time. Any attempt to overwrite or delete objects younger than the
	// retention period will result in a PERMISSION_DENIED error.  An unlocked
	// retention policy can be modified or removed from the bucket via a
	// storage.buckets.update operation. A locked retention policy cannot be
	// removed or shortened in duration for the lifetime of the bucket.
	// Attempting to remove or decrease period of a locked retention policy will
	// result in a PERMISSION_DENIED error.
	RetentionPolicy *Bucket_RetentionPolicy `protobuf:"bytes,22,opt,name=retention_policy,json=retentionPolicy,proto3" json:"retention_policy,omitempty"`
	// The bucket's IAM config.
	IamConfig *Bucket_IamConfig `protobuf:"bytes,23,opt,name=iam_config,json=iamConfig,proto3" json:"iam_config,omitempty"`
	// Immutable. The zone or zones from which the bucket is intended to use zonal quota.
	// Requests for data from outside the specified affinities are still allowed
	// but won't be able to use zonal quota. The values are case-insensitive.
	// Attempting to update this field after bucket is created will result in an
	// error.
	ZoneAffinity []string `protobuf:"bytes,24,rep,name=zone_affinity,json=zoneAffinity,proto3" json:"zone_affinity,omitempty"`
	// Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,25,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
}

func (x *Bucket) Reset() {
	*x = Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket) ProtoMessage() {}

func (x *Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket.ProtoReflect.Descriptor instead.
func (*Bucket) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12}
}

func (x *Bucket) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Bucket) GetBucketId() string {
	if x != nil {
		return x.BucketId
	}
	return ""
}

func (x *Bucket) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Bucket) GetMetageneration() int64 {
	if x != nil {
		return x.Metageneration
	}
	return 0
}

func (x *Bucket) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Bucket) GetLocationType() string {
	if x != nil {
		return x.LocationType
	}
	return ""
}

func (x *Bucket) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *Bucket) GetAcl() []*BucketAccessControl {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Bucket) GetDefaultObjectAcl() []*ObjectAccessControl {
	if x != nil {
		return x.DefaultObjectAcl
	}
	return nil
}

func (x *Bucket) GetLifecycle() *Bucket_Lifecycle {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

func (x *Bucket) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Bucket) GetCors() []*Bucket_Cors {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *Bucket) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Bucket) GetDefaultEventBasedHold() bool {
	if x != nil {
		return x.DefaultEventBasedHold
	}
	return false
}

func (x *Bucket) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Bucket) GetWebsite() *Bucket_Website {
	if x != nil {
		return x.Website
	}
	return nil
}

func (x *Bucket) GetVersioning() *Bucket_Versioning {
	if x != nil {
		return x.Versioning
	}
	return nil
}

func (x *Bucket) GetLogging() *Bucket_Logging {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Bucket) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *Bucket) GetEncryption() *Bucket_Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *Bucket) GetBilling() *Bucket_Billing {
	if x != nil {
		return x.Billing
	}
	return nil
}

func (x *Bucket) GetRetentionPolicy() *Bucket_RetentionPolicy {
	if x != nil {
		return x.RetentionPolicy
	}
	return nil
}

func (x *Bucket) GetIamConfig() *Bucket_IamConfig {
	if x != nil {
		return x.IamConfig
	}
	return nil
}

func (x *Bucket) GetZoneAffinity() []string {
	if x != nil {
		return x.ZoneAffinity
	}
	return nil
}

func (x *Bucket) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

// An access-control entry.
type BucketAccessControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The access permission for the entity.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// The ID of the access-control entry.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The entity holding the permission, in one of the following forms:
	// * `user-{userid}`
	// * `user-{email}`
	// * `group-{groupid}`
	// * `group-{email}`
	// * `domain-{domain}`
	// * `project-{team-projectid}`
	// * `allUsers`
	// * `allAuthenticatedUsers`
	// Examples:
	// * The user `liz@example.com` would be `user-liz@example.com`.
	// * The group `example@googlegroups.com` would be
	// `group-example@googlegroups.com`
	// * All members of the Google Apps for Business domain `example.com` would be
	// `domain-example.com`
	Entity string `protobuf:"bytes,3,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity, if any.
	EntityId string `protobuf:"bytes,4,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The email address associated with the entity, if any.
	Email string `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// The domain associated with the entity, if any.
	Domain string `protobuf:"bytes,6,opt,name=domain,proto3" json:"domain,omitempty"`
	// The project team associated with the entity, if any.
	ProjectTeam *ProjectTeam `protobuf:"bytes,7,opt,name=project_team,json=projectTeam,proto3" json:"project_team,omitempty"`
}

func (x *BucketAccessControl) Reset() {
	*x = BucketAccessControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketAccessControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketAccessControl) ProtoMessage() {}

func (x *BucketAccessControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketAccessControl.ProtoReflect.Descriptor instead.
func (*BucketAccessControl) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{13}
}

func (x *BucketAccessControl) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *BucketAccessControl) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BucketAccessControl) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *BucketAccessControl) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *BucketAccessControl) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *BucketAccessControl) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *BucketAccessControl) GetProjectTeam() *ProjectTeam {
	if x != nil {
		return x.ProjectTeam
	}
	return nil
}

// Message used to convey content being read or written, along with an optional
// checksum.
type ChecksummedData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// If set, the CRC32C digest of the content field.
	Crc32C *uint32 `protobuf:"fixed32,2,opt,name=crc32c,proto3,oneof" json:"crc32c,omitempty"`
}

func (x *ChecksummedData) Reset() {
	*x = ChecksummedData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChecksummedData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChecksummedData) ProtoMessage() {}

func (x *ChecksummedData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChecksummedData.ProtoReflect.Descriptor instead.
func (*ChecksummedData) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{14}
}

func (x *ChecksummedData) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *ChecksummedData) GetCrc32C() uint32 {
	if x != nil && x.Crc32C != nil {
		return *x.Crc32C
	}
	return 0
}

// Message used for storing full (not subrange) object checksums.
type ObjectChecksums struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CRC32C digest of the object data. Computed by the Cloud Storage service for
	// all written objects.
	// If set in an WriteObjectRequest, service will validate that the stored
	// object matches this checksum.
	Crc32C *uint32 `protobuf:"fixed32,1,opt,name=crc32c,proto3,oneof" json:"crc32c,omitempty"`
	// 128 bit MD5 hash of the object data.
	// For more information about using the MD5 hash, see
	// [https://cloud.google.com/storage/docs/hashes-etags#json-api][Hashes and
	// ETags: Best Practices].
	// Not all objects will provide an MD5 hash. For example, composite objects
	// provide only crc32c hashes.
	// This value is equivalent to running `cat object.txt | openssl md5 -binary`
	Md5Hash []byte `protobuf:"bytes,2,opt,name=md5_hash,json=md5Hash,proto3" json:"md5_hash,omitempty"`
}

func (x *ObjectChecksums) Reset() {
	*x = ObjectChecksums{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectChecksums) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectChecksums) ProtoMessage() {}

func (x *ObjectChecksums) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectChecksums.ProtoReflect.Descriptor instead.
func (*ObjectChecksums) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{15}
}

func (x *ObjectChecksums) GetCrc32C() uint32 {
	if x != nil && x.Crc32C != nil {
		return *x.Crc32C
	}
	return 0
}

func (x *ObjectChecksums) GetMd5Hash() []byte {
	if x != nil {
		return x.Md5Hash
	}
	return nil
}

// An object.
type Object struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of this object. Nearly any sequence of unicode characters is
	// valid. See
	// [Guidelines](https://cloud.google.com/storage/docs/naming-objects).
	// Example: `test.txt`
	// The `name` field by itself does not uniquely identify a Cloud Storage
	// object. A Cloud Storage object is uniquely identified by the tuple of
	// (bucket, object, generation).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The name of the bucket containing this object.
	// Example: `projects/_/buckets/foo`.
	Bucket string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Immutable. The content generation of this object. Used for object versioning.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Output only. The version of the metadata for this generation of this object. Used for
	// preconditions and for detecting changes in metadata. A metageneration
	// number is only meaningful in the context of a particular generation of a
	// particular object.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	Metageneration int64 `protobuf:"varint,4,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// Storage class of the object.
	StorageClass string `protobuf:"bytes,5,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Output only. Content-Length of the object data in bytes, matching
	// [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	Size int64 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
	// Content-Encoding of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
	ContentEncoding string `protobuf:"bytes,7,opt,name=content_encoding,json=contentEncoding,proto3" json:"content_encoding,omitempty"`
	// Content-Disposition of the object data, matching
	// [https://tools.ietf.org/html/rfc6266][RFC 6266].
	ContentDisposition string `protobuf:"bytes,8,opt,name=content_disposition,json=contentDisposition,proto3" json:"content_disposition,omitempty"`
	// Cache-Control directive for the object data, matching
	// [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
	// If omitted, and the object is accessible to all anonymous users, the
	// default will be `public, max-age=3600`.
	CacheControl string `protobuf:"bytes,9,opt,name=cache_control,json=cacheControl,proto3" json:"cache_control,omitempty"`
	// Access controls on the object.
	// If iamConfig.uniformBucketLevelAccess is enabled on the parent
	// bucket, requests to set, read, or modify acl is an error.
	Acl []*ObjectAccessControl `protobuf:"bytes,10,rep,name=acl,proto3" json:"acl,omitempty"`
	// Content-Language of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
	ContentLanguage string `protobuf:"bytes,11,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
	// Output only. The deletion time of the object. Will be returned if and only if this
	// version of the object has been deleted.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Content-Type of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
	// If an object is stored without a Content-Type, it is served as
	// `application/octet-stream`.
	ContentType string `protobuf:"bytes,13,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Output only. The creation time of the object.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Number of underlying components that make up this object. Components are
	// accumulated by compose operations.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	ComponentCount int32 `protobuf:"varint,15,opt,name=component_count,json=componentCount,proto3" json:"component_count,omitempty"`
	// Output only. Hashes for the data part of this object.
	Checksums *ObjectChecksums `protobuf:"bytes,16,opt,name=checksums,proto3" json:"checksums,omitempty"`
	// Output only. The modification time of the object metadata.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Cloud KMS Key used to encrypt this object, if the object is encrypted by
	// such a key.
	KmsKey string `protobuf:"bytes,18,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Output only. The time at which the object's storage class was last changed. When the
	// object is initially created, it will be set to time_created.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	UpdateStorageClassTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=update_storage_class_time,json=updateStorageClassTime,proto3" json:"update_storage_class_time,omitempty"`
	// Whether an object is under temporary hold. While this flag is set to true,
	// the object is protected against deletion and overwrites.  A common use case
	// of this flag is regulatory investigations where objects need to be retained
	// while the investigation is ongoing. Note that unlike event-based hold,
	// temporary hold does not impact retention expiration time of an object.
	TemporaryHold bool `protobuf:"varint,20,opt,name=temporary_hold,json=temporaryHold,proto3" json:"temporary_hold,omitempty"`
	// A server-determined value that specifies the earliest time that the
	// object's retention period expires. This value is in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	// Note 1: This field is not provided for objects with an active event-based
	// hold, since retention expiration is unknown until the hold is removed.
	// Note 2: This value can be provided even when temporary hold is set (so that
	// the user can reason about policy without having to first unset the
	// temporary hold).
	RetentionExpireTime *timestamppb.Timestamp `protobuf:"bytes,21,opt,name=retention_expire_time,json=retentionExpireTime,proto3" json:"retention_expire_time,omitempty"`
	// User-provided metadata, in key/value pairs.
	Metadata map[string]string `protobuf:"bytes,22,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether an object is under event-based hold.
	// An event-based hold is a way to force the retention of an object until
	// after some event occurs. Once the hold is released by explicitly setting
	// this field to false, the object will become subject to any bucket-level
	// retention policy, except that the retention duration will be calculated
	// from the time the event based hold was lifted, rather than the time the
	// object was created.
	//
	// In a WriteObject request, not setting this field implies that the value
	// should be taken from the parent bucket's "default_event_based_hold" field.
	// In a response, this field will always be set to true or false.
	EventBasedHold *bool `protobuf:"varint,23,opt,name=event_based_hold,json=eventBasedHold,proto3,oneof" json:"event_based_hold,omitempty"`
	// Output only. The owner of the object. This will always be the uploader of the object.
	// Attempting to set or update this field will result in a
	// [FieldViolation][google.rpc.BadRequest.FieldViolation].
	Owner *Owner `protobuf:"bytes,24,opt,name=owner,proto3" json:"owner,omitempty"`
	// Metadata of customer-supplied encryption key, if the object is encrypted by
	// such a key.
	CustomerEncryption *Object_CustomerEncryption `protobuf:"bytes,25,opt,name=customer_encryption,json=customerEncryption,proto3" json:"customer_encryption,omitempty"`
	// A user-specified timestamp set on an object.
	CustomTime *timestamppb.Timestamp `protobuf:"bytes,26,opt,name=custom_time,json=customTime,proto3" json:"custom_time,omitempty"`
}

func (x *Object) Reset() {
	*x = Object{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Object) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Object) ProtoMessage() {}

func (x *Object) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Object.ProtoReflect.Descriptor instead.
func (*Object) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{16}
}

func (x *Object) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Object) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *Object) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *Object) GetMetageneration() int64 {
	if x != nil {
		return x.Metageneration
	}
	return 0
}

func (x *Object) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *Object) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Object) GetContentEncoding() string {
	if x != nil {
		return x.ContentEncoding
	}
	return ""
}

func (x *Object) GetContentDisposition() string {
	if x != nil {
		return x.ContentDisposition
	}
	return ""
}

func (x *Object) GetCacheControl() string {
	if x != nil {
		return x.CacheControl
	}
	return ""
}

func (x *Object) GetAcl() []*ObjectAccessControl {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Object) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

func (x *Object) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Object) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *Object) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Object) GetComponentCount() int32 {
	if x != nil {
		return x.ComponentCount
	}
	return 0
}

func (x *Object) GetChecksums() *ObjectChecksums {
	if x != nil {
		return x.Checksums
	}
	return nil
}

func (x *Object) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Object) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *Object) GetUpdateStorageClassTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateStorageClassTime
	}
	return nil
}

func (x *Object) GetTemporaryHold() bool {
	if x != nil {
		return x.TemporaryHold
	}
	return false
}

func (x *Object) GetRetentionExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RetentionExpireTime
	}
	return nil
}

func (x *Object) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Object) GetEventBasedHold() bool {
	if x != nil && x.EventBasedHold != nil {
		return *x.EventBasedHold
	}
	return false
}

func (x *Object) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *Object) GetCustomerEncryption() *Object_CustomerEncryption {
	if x != nil {
		return x.CustomerEncryption
	}
	return nil
}

func (x *Object) GetCustomTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CustomTime
	}
	return nil
}

// An access-control entry.
type ObjectAccessControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The access permission for the entity.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// The ID of the access-control entry.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The entity holding the permission, in one of the following forms:
	// * `user-{userid}`
	// * `user-{email}`
	// * `group-{groupid}`
	// * `group-{email}`
	// * `domain-{domain}`
	// * `project-{team-projectid}`
	// * `allUsers`
	// * `allAuthenticatedUsers`
	// Examples:
	// * The user `liz@example.com` would be `user-liz@example.com`.
	// * The group `example@googlegroups.com` would be
	// `group-example@googlegroups.com`.
	// * All members of the Google Apps for Business domain `example.com` would be
	// `domain-example.com`.
	Entity string `protobuf:"bytes,3,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity, if any.
	EntityId string `protobuf:"bytes,4,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The email address associated with the entity, if any.
	Email string `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// The domain associated with the entity, if any.
	Domain string `protobuf:"bytes,6,opt,name=domain,proto3" json:"domain,omitempty"`
	// The project team associated with the entity, if any.
	ProjectTeam *ProjectTeam `protobuf:"bytes,7,opt,name=project_team,json=projectTeam,proto3" json:"project_team,omitempty"`
}

func (x *ObjectAccessControl) Reset() {
	*x = ObjectAccessControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectAccessControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectAccessControl) ProtoMessage() {}

func (x *ObjectAccessControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectAccessControl.ProtoReflect.Descriptor instead.
func (*ObjectAccessControl) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{17}
}

func (x *ObjectAccessControl) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *ObjectAccessControl) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ObjectAccessControl) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *ObjectAccessControl) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *ObjectAccessControl) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ObjectAccessControl) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *ObjectAccessControl) GetProjectTeam() *ProjectTeam {
	if x != nil {
		return x.ProjectTeam
	}
	return nil
}

// Represents the Viewers, Editors, or Owners of a given project.
type ProjectTeam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project number.
	ProjectNumber string `protobuf:"bytes,1,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The team.
	Team string `protobuf:"bytes,2,opt,name=team,proto3" json:"team,omitempty"`
}

func (x *ProjectTeam) Reset() {
	*x = ProjectTeam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectTeam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectTeam) ProtoMessage() {}

func (x *ProjectTeam) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectTeam.ProtoReflect.Descriptor instead.
func (*ProjectTeam) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{18}
}

func (x *ProjectTeam) GetProjectNumber() string {
	if x != nil {
		return x.ProjectNumber
	}
	return ""
}

func (x *ProjectTeam) GetTeam() string {
	if x != nil {
		return x.Team
	}
	return ""
}

// The owner of a specific resource.
type Owner struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entity, in the form `user-`*userId*.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity.
	EntityId string `protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
}

func (x *Owner) Reset() {
	*x = Owner{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Owner) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Owner) ProtoMessage() {}

func (x *Owner) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Owner.ProtoReflect.Descriptor instead.
func (*Owner) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{19}
}

func (x *Owner) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *Owner) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

// Specifies a requested range of bytes to download.
type ContentRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The starting offset of the object data.
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The ending offset of the object data.
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// The complete length of the object data.
	CompleteLength int64 `protobuf:"varint,3,opt,name=complete_length,json=completeLength,proto3" json:"complete_length,omitempty"`
}

func (x *ContentRange) Reset() {
	*x = ContentRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentRange) ProtoMessage() {}

func (x *ContentRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentRange.ProtoReflect.Descriptor instead.
func (*ContentRange) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{20}
}

func (x *ContentRange) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *ContentRange) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *ContentRange) GetCompleteLength() int64 {
	if x != nil {
		return x.CompleteLength
	}
	return 0
}

// Billing properties of a bucket.
type Bucket_Billing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When set to true, Requester Pays is enabled for this bucket.
	RequesterPays bool `protobuf:"varint,1,opt,name=requester_pays,json=requesterPays,proto3" json:"requester_pays,omitempty"`
}

func (x *Bucket_Billing) Reset() {
	*x = Bucket_Billing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Billing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Billing) ProtoMessage() {}

func (x *Bucket_Billing) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Billing.ProtoReflect.Descriptor instead.
func (*Bucket_Billing) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Bucket_Billing) GetRequesterPays() bool {
	if x != nil {
		return x.RequesterPays
	}
	return false
}

// Cross-Origin Response sharing (CORS) properties for a bucket.
// For more on Cloud Storage and CORS, see
// https://cloud.google.com/storage/docs/cross-origin.
// For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
type Bucket_Cors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Origins eligible to receive CORS response headers. See
	// [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
	// Note: "*" is permitted in the list of origins, and means "any Origin".
	Origin []string `protobuf:"bytes,1,rep,name=origin,proto3" json:"origin,omitempty"`
	// The list of HTTP methods on which to include CORS response headers,
	// (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
	// methods, and means "any method".
	Method []string `protobuf:"bytes,2,rep,name=method,proto3" json:"method,omitempty"`
	// The list of HTTP headers other than the
	// [https://www.w3.org/TR/cors/#simple-response-header][simple response
	// headers] to give permission for the user-agent to share across domains.
	ResponseHeader []string `protobuf:"bytes,3,rep,name=response_header,json=responseHeader,proto3" json:"response_header,omitempty"`
	// The value, in seconds, to return in the
	// [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
	// header] used in preflight responses.
	MaxAgeSeconds int32 `protobuf:"varint,4,opt,name=max_age_seconds,json=maxAgeSeconds,proto3" json:"max_age_seconds,omitempty"`
}

func (x *Bucket_Cors) Reset() {
	*x = Bucket_Cors{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Cors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Cors) ProtoMessage() {}

func (x *Bucket_Cors) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Cors.ProtoReflect.Descriptor instead.
func (*Bucket_Cors) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 1}
}

func (x *Bucket_Cors) GetOrigin() []string {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *Bucket_Cors) GetMethod() []string {
	if x != nil {
		return x.Method
	}
	return nil
}

func (x *Bucket_Cors) GetResponseHeader() []string {
	if x != nil {
		return x.ResponseHeader
	}
	return nil
}

func (x *Bucket_Cors) GetMaxAgeSeconds() int32 {
	if x != nil {
		return x.MaxAgeSeconds
	}
	return 0
}

// Encryption properties of a bucket.
type Bucket_Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Cloud KMS key that will be used to encrypt objects inserted into this
	// bucket, if no encryption method is specified.
	DefaultKmsKey string `protobuf:"bytes,1,opt,name=default_kms_key,json=defaultKmsKey,proto3" json:"default_kms_key,omitempty"`
}

func (x *Bucket_Encryption) Reset() {
	*x = Bucket_Encryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Encryption) ProtoMessage() {}

func (x *Bucket_Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Encryption.ProtoReflect.Descriptor instead.
func (*Bucket_Encryption) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 2}
}

func (x *Bucket_Encryption) GetDefaultKmsKey() string {
	if x != nil {
		return x.DefaultKmsKey
	}
	return ""
}

// Bucket restriction options.
type Bucket_IamConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket restriction options currently enforced on the bucket.
	UniformBucketLevelAccess *Bucket_IamConfig_UniformBucketLevelAccess `protobuf:"bytes,1,opt,name=uniform_bucket_level_access,json=uniformBucketLevelAccess,proto3" json:"uniform_bucket_level_access,omitempty"`
	// Whether IAM will enforce public access prevention.
	PublicAccessPrevention Bucket_IamConfig_PublicAccessPrevention `protobuf:"varint,2,opt,name=public_access_prevention,json=publicAccessPrevention,proto3,enum=google.storage.v2.Bucket_IamConfig_PublicAccessPrevention" json:"public_access_prevention,omitempty"`
}

func (x *Bucket_IamConfig) Reset() {
	*x = Bucket_IamConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_IamConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_IamConfig) ProtoMessage() {}

func (x *Bucket_IamConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_IamConfig.ProtoReflect.Descriptor instead.
func (*Bucket_IamConfig) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 3}
}

func (x *Bucket_IamConfig) GetUniformBucketLevelAccess() *Bucket_IamConfig_UniformBucketLevelAccess {
	if x != nil {
		return x.UniformBucketLevelAccess
	}
	return nil
}

func (x *Bucket_IamConfig) GetPublicAccessPrevention() Bucket_IamConfig_PublicAccessPrevention {
	if x != nil {
		return x.PublicAccessPrevention
	}
	return Bucket_IamConfig_PUBLIC_ACCESS_PREVENTION_UNSPECIFIED
}

// Lifecycle properties of a bucket.
// For more information, see https://cloud.google.com/storage/docs/lifecycle.
type Bucket_Lifecycle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A lifecycle management rule, which is made of an action to take and the
	// condition(s) under which the action will be taken.
	Rule []*Bucket_Lifecycle_Rule `protobuf:"bytes,1,rep,name=rule,proto3" json:"rule,omitempty"`
}

func (x *Bucket_Lifecycle) Reset() {
	*x = Bucket_Lifecycle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle) ProtoMessage() {}

func (x *Bucket_Lifecycle) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 4}
}

func (x *Bucket_Lifecycle) GetRule() []*Bucket_Lifecycle_Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

// Logging-related properties of a bucket.
type Bucket_Logging struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination bucket where the current bucket's logs should be placed.
	LogBucket string `protobuf:"bytes,1,opt,name=log_bucket,json=logBucket,proto3" json:"log_bucket,omitempty"`
	// A prefix for log object names.
	LogObjectPrefix string `protobuf:"bytes,2,opt,name=log_object_prefix,json=logObjectPrefix,proto3" json:"log_object_prefix,omitempty"`
}

func (x *Bucket_Logging) Reset() {
	*x = Bucket_Logging{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Logging) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Logging) ProtoMessage() {}

func (x *Bucket_Logging) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Logging.ProtoReflect.Descriptor instead.
func (*Bucket_Logging) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 5}
}

func (x *Bucket_Logging) GetLogBucket() string {
	if x != nil {
		return x.LogBucket
	}
	return ""
}

func (x *Bucket_Logging) GetLogObjectPrefix() string {
	if x != nil {
		return x.LogObjectPrefix
	}
	return ""
}

// Retention policy properties of a bucket.
type Bucket_RetentionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Server-determined value that indicates the time from which policy was
	// enforced and effective. This value is in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	EffectiveTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=effective_time,json=effectiveTime,proto3" json:"effective_time,omitempty"`
	// Once locked, an object retention policy cannot be modified.
	IsLocked bool `protobuf:"varint,2,opt,name=is_locked,json=isLocked,proto3" json:"is_locked,omitempty"`
	// The duration in seconds that objects need to be retained. Retention
	// duration must be greater than zero and less than 100 years. Note that
	// enforcement of retention periods less than a day is not guaranteed. Such
	// periods should only be used for testing purposes.
	RetentionPeriod int64 `protobuf:"varint,3,opt,name=retention_period,json=retentionPeriod,proto3" json:"retention_period,omitempty"`
}

func (x *Bucket_RetentionPolicy) Reset() {
	*x = Bucket_RetentionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_RetentionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_RetentionPolicy) ProtoMessage() {}

func (x *Bucket_RetentionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_RetentionPolicy.ProtoReflect.Descriptor instead.
func (*Bucket_RetentionPolicy) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 6}
}

func (x *Bucket_RetentionPolicy) GetEffectiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EffectiveTime
	}
	return nil
}

func (x *Bucket_RetentionPolicy) GetIsLocked() bool {
	if x != nil {
		return x.IsLocked
	}
	return false
}

func (x *Bucket_RetentionPolicy) GetRetentionPeriod() int64 {
	if x != nil {
		return x.RetentionPeriod
	}
	return 0
}

// Properties of a bucket related to versioning.
// For more on Cloud Storage versioning, see
// https://cloud.google.com/storage/docs/object-versioning.
type Bucket_Versioning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// While set to true, versioning is fully enabled for this bucket.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *Bucket_Versioning) Reset() {
	*x = Bucket_Versioning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Versioning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Versioning) ProtoMessage() {}

func (x *Bucket_Versioning) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Versioning.ProtoReflect.Descriptor instead.
func (*Bucket_Versioning) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 7}
}

func (x *Bucket_Versioning) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Properties of a bucket related to accessing the contents as a static
// website. For more on hosting a static website via Cloud Storage, see
// https://cloud.google.com/storage/docs/hosting-static-website.
type Bucket_Website struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the requested object path is missing, the service will ensure the path
	// has a trailing '/', append this suffix, and attempt to retrieve the
	// resulting object. This allows the creation of `index.html`
	// objects to represent directory pages.
	MainPageSuffix string `protobuf:"bytes,1,opt,name=main_page_suffix,json=mainPageSuffix,proto3" json:"main_page_suffix,omitempty"`
	// If the requested object path is missing, and any
	// `mainPageSuffix` object is missing, if applicable, the service
	// will return the named object from this bucket as the content for a
	// [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
	// result.
	NotFoundPage string `protobuf:"bytes,2,opt,name=not_found_page,json=notFoundPage,proto3" json:"not_found_page,omitempty"`
}

func (x *Bucket_Website) Reset() {
	*x = Bucket_Website{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Website) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Website) ProtoMessage() {}

func (x *Bucket_Website) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Website.ProtoReflect.Descriptor instead.
func (*Bucket_Website) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 8}
}

func (x *Bucket_Website) GetMainPageSuffix() string {
	if x != nil {
		return x.MainPageSuffix
	}
	return ""
}

func (x *Bucket_Website) GetNotFoundPage() string {
	if x != nil {
		return x.NotFoundPage
	}
	return ""
}

// Settings for Uniform Bucket level access.
// See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
type Bucket_IamConfig_UniformBucketLevelAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, access checks only use bucket-level IAM policies or above.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The deadline time for changing
	// `iamConfig.uniformBucketLevelAccess.enabled` from
	// true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
	// Mutable until the specified deadline is reached, but not afterward.
	LockTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=lock_time,json=lockTime,proto3" json:"lock_time,omitempty"`
}

func (x *Bucket_IamConfig_UniformBucketLevelAccess) Reset() {
	*x = Bucket_IamConfig_UniformBucketLevelAccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_IamConfig_UniformBucketLevelAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_IamConfig_UniformBucketLevelAccess) ProtoMessage() {}

func (x *Bucket_IamConfig_UniformBucketLevelAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_IamConfig_UniformBucketLevelAccess.ProtoReflect.Descriptor instead.
func (*Bucket_IamConfig_UniformBucketLevelAccess) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 3, 0}
}

func (x *Bucket_IamConfig_UniformBucketLevelAccess) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Bucket_IamConfig_UniformBucketLevelAccess) GetLockTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LockTime
	}
	return nil
}

// A lifecycle Rule, combining an action to take on an object and a
// condition which will trigger that action.
type Bucket_Lifecycle_Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The action to take.
	Action *Bucket_Lifecycle_Rule_Action `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// The condition(s) under which the action will be taken.
	Condition *Bucket_Lifecycle_Rule_Condition `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *Bucket_Lifecycle_Rule) Reset() {
	*x = Bucket_Lifecycle_Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle_Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle_Rule) ProtoMessage() {}

func (x *Bucket_Lifecycle_Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle_Rule.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle_Rule) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 4, 0}
}

func (x *Bucket_Lifecycle_Rule) GetAction() *Bucket_Lifecycle_Rule_Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule) GetCondition() *Bucket_Lifecycle_Rule_Condition {
	if x != nil {
		return x.Condition
	}
	return nil
}

// An action to take on an object.
type Bucket_Lifecycle_Rule_Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the action. Currently, only `Delete` and
	// `SetStorageClass` are supported.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Target storage class. Required iff the type of the action is
	// SetStorageClass.
	StorageClass string `protobuf:"bytes,2,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
}

func (x *Bucket_Lifecycle_Rule_Action) Reset() {
	*x = Bucket_Lifecycle_Rule_Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle_Rule_Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle_Rule_Action) ProtoMessage() {}

func (x *Bucket_Lifecycle_Rule_Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle_Rule_Action.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle_Rule_Action) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 4, 0, 0}
}

func (x *Bucket_Lifecycle_Rule_Action) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Bucket_Lifecycle_Rule_Action) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

// A condition of an object which triggers some action.
type Bucket_Lifecycle_Rule_Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Age of an object (in days). This condition is satisfied when an
	// object reaches the specified age.
	AgeDays int32 `protobuf:"varint,1,opt,name=age_days,json=ageDays,proto3" json:"age_days,omitempty"`
	// A date in [RFC 3339][1] format with only the date part (for
	// instance, "2013-01-15"). This condition is satisfied when an
	// object is created before midnight of the specified date in UTC.
	// [1]: https://tools.ietf.org/html/rfc3339
	CreatedBeforeTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_before_time,json=createdBeforeTime,proto3" json:"created_before_time,omitempty"`
	// Relevant only for versioned objects. If the value is
	// `true`, this condition matches live objects; if the value
	// is `false`, it matches archived objects.
	IsLive *bool `protobuf:"varint,3,opt,name=is_live,json=isLive,proto3,oneof" json:"is_live,omitempty"`
	// Relevant only for versioned objects. If the value is N, this
	// condition is satisfied when there are at least N versions (including
	// the live version) newer than this version of the object.
	NumNewerVersions int32 `protobuf:"varint,4,opt,name=num_newer_versions,json=numNewerVersions,proto3" json:"num_newer_versions,omitempty"`
	// Objects having any of the storage classes specified by this condition
	// will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
	// `NEARLINE`, `COLDLINE`, `STANDARD`, and
	// `DURABLE_REDUCED_AVAILABILITY`.
	MatchesStorageClass []string `protobuf:"bytes,5,rep,name=matches_storage_class,json=matchesStorageClass,proto3" json:"matches_storage_class,omitempty"`
	// A regular expression that satisfies the RE2 syntax. This condition is
	// satisfied when the name of the object matches the RE2 pattern.  Note:
	// This feature is currently in the "Early Access" launch stage and is
	// only available to an allowlisted set of users; that means that this
	// feature may be changed in backward-incompatible ways and that it is
	// not guaranteed to be released.
	MatchesPattern string `protobuf:"bytes,6,opt,name=matches_pattern,json=matchesPattern,proto3" json:"matches_pattern,omitempty"`
	// Number of days that has elapsed since the custom timestamp set on an
	// object.
	DaysSinceCustomTime int32 `protobuf:"varint,7,opt,name=days_since_custom_time,json=daysSinceCustomTime,proto3" json:"days_since_custom_time,omitempty"`
	// An object matches this condition if the custom timestamp set on the
	// object is before this timestamp.
	CustomTimeBeforeTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=custom_time_before_time,json=customTimeBeforeTime,proto3" json:"custom_time_before_time,omitempty"`
	// This condition is relevant only for versioned objects. An object
	// version satisfies this condition only if these many days have been
	// passed since it became noncurrent. The value of the field must be a
	// nonnegative integer. If it's zero, the object version will become
	// eligible for Lifecycle action as soon as it becomes noncurrent.
	DaysSinceNoncurrentTime int32 `protobuf:"varint,9,opt,name=days_since_noncurrent_time,json=daysSinceNoncurrentTime,proto3" json:"days_since_noncurrent_time,omitempty"`
	// This condition is relevant only for versioned objects. An object
	// version satisfies this condition only if it became noncurrent before
	// the specified timestamp.
	NoncurrentTimeBeforeTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=noncurrent_time_before_time,json=noncurrentTimeBeforeTime,proto3" json:"noncurrent_time_before_time,omitempty"`
}

func (x *Bucket_Lifecycle_Rule_Condition) Reset() {
	*x = Bucket_Lifecycle_Rule_Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle_Rule_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle_Rule_Condition) ProtoMessage() {}

func (x *Bucket_Lifecycle_Rule_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle_Rule_Condition.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle_Rule_Condition) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{12, 4, 0, 1}
}

func (x *Bucket_Lifecycle_Rule_Condition) GetAgeDays() int32 {
	if x != nil {
		return x.AgeDays
	}
	return 0
}

func (x *Bucket_Lifecycle_Rule_Condition) GetCreatedBeforeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedBeforeTime
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule_Condition) GetIsLive() bool {
	if x != nil && x.IsLive != nil {
		return *x.IsLive
	}
	return false
}

func (x *Bucket_Lifecycle_Rule_Condition) GetNumNewerVersions() int32 {
	if x != nil {
		return x.NumNewerVersions
	}
	return 0
}

func (x *Bucket_Lifecycle_Rule_Condition) GetMatchesStorageClass() []string {
	if x != nil {
		return x.MatchesStorageClass
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule_Condition) GetMatchesPattern() string {
	if x != nil {
		return x.MatchesPattern
	}
	return ""
}

func (x *Bucket_Lifecycle_Rule_Condition) GetDaysSinceCustomTime() int32 {
	if x != nil {
		return x.DaysSinceCustomTime
	}
	return 0
}

func (x *Bucket_Lifecycle_Rule_Condition) GetCustomTimeBeforeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CustomTimeBeforeTime
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule_Condition) GetDaysSinceNoncurrentTime() int32 {
	if x != nil {
		return x.DaysSinceNoncurrentTime
	}
	return 0
}

func (x *Bucket_Lifecycle_Rule_Condition) GetNoncurrentTimeBeforeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NoncurrentTimeBeforeTime
	}
	return nil
}

// Describes the customer-specified mechanism used to store the data at rest.
type Object_CustomerEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encryption algorithm.
	EncryptionAlgorithm string `protobuf:"bytes,1,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	// SHA256 hash value of the encryption key.
	KeySha256 string `protobuf:"bytes,2,opt,name=key_sha256,json=keySha256,proto3" json:"key_sha256,omitempty"`
}

func (x *Object_CustomerEncryption) Reset() {
	*x = Object_CustomerEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v2_storage_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Object_CustomerEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Object_CustomerEncryption) ProtoMessage() {}

func (x *Object_CustomerEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v2_storage_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Object_CustomerEncryption.ProtoReflect.Descriptor instead.
func (*Object_CustomerEncryption) Descriptor() ([]byte, []int) {
	return file_google_storage_v2_storage_proto_rawDescGZIP(), []int{16, 0}
}

func (x *Object_CustomerEncryption) GetEncryptionAlgorithm() string {
	if x != nil {
		return x.EncryptionAlgorithm
	}
	return ""
}

func (x *Object_CustomerEncryption) GetKeySha256() string {
	if x != nil {
		return x.KeySha256
	}
	return ""
}

var File_google_storage_v2_storage_proto protoreflect.FileDescriptor

var file_google_storage_v2_storage_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9c, 0x06, 0x0a, 0x11, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x69,
	0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01,
	0x12, 0x3a, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x01, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17,
	0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52,
	0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x69, 0x66, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03,
	0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x6d, 0x0a,
	0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x3c, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x48, 0x04, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x88, 0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x69, 0x66, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1a,
	0x0a, 0x18, 0x5f, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x69,
	0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x22, 0xaf, 0x02, 0x0a, 0x12, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x10, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a, 0x10, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x52, 0x0f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xf9, 0x03, 0x0a, 0x0f, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x35, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x61, 0x63, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63,
	0x6c, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c,
	0x12, 0x33, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01,
	0x01, 0x12, 0x3b, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x02, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x42,
	0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88,
	0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x69,
	0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x22, 0xd4, 0x04, 0x0a, 0x12, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x75, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08,
	0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x4f, 0x0a, 0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x01, 0x52, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a, 0x10, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d,
	0x73, 0x52, 0x0f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x42, 0x0f, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x87, 0x01, 0x0a, 0x13, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x27, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x86, 0x02, 0x0a, 0x17, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x8c, 0x01, 0x0a,
	0x18, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0e, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x48,
	0x00, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xb7, 0x02, 0x0a, 0x1a,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x11, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x3a, 0x0a, 0x1b, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x22, 0xa9, 0x01, 0x0a, 0x19, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x31, 0x0a, 0x14, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x68, 0x61, 0x32,
	0x35, 0x36, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x6d, 0x0a,
	0x13, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0x56, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x0b, 0x75, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xca, 0x05, 0x0a,
	0x10, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x73, 0x22, 0xb5, 0x05, 0x0a, 0x06, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x12,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x14, 0x4d, 0x41, 0x58, 0x5f, 0x52, 0x45, 0x41, 0x44,
	0x5f, 0x43, 0x48, 0x55, 0x4e, 0x4b, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0x80, 0x80,
	0x01, 0x12, 0x1c, 0x0a, 0x15, 0x4d, 0x41, 0x58, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x43,
	0x48, 0x55, 0x4e, 0x4b, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0x80, 0x80, 0x01, 0x12,
	0x19, 0x0a, 0x12, 0x4d, 0x41, 0x58, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x53, 0x49,
	0x5a, 0x45, 0x5f, 0x4d, 0x42, 0x10, 0x80, 0x80, 0xc0, 0x02, 0x12, 0x29, 0x0a, 0x24, 0x4d, 0x41,
	0x58, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x42, 0x59, 0x54,
	0x45, 0x53, 0x10, 0x80, 0x08, 0x12, 0x2a, 0x0a, 0x25, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x49, 0x45,
	0x4c, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80,
	0x20, 0x12, 0x29, 0x0a, 0x24, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f,
	0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x53,
	0x49, 0x5a, 0x45, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0x40, 0x12, 0x2a, 0x0a, 0x24,
	0x4d, 0x41, 0x58, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x42,
	0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0xa0, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x4d, 0x41, 0x58, 0x5f,
	0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10,
	0x64, 0x12, 0x22, 0x0a, 0x1e, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x49, 0x46, 0x45, 0x43, 0x59, 0x43,
	0x4c, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x42, 0x55, 0x43,
	0x4b, 0x45, 0x54, 0x10, 0x64, 0x12, 0x26, 0x0a, 0x22, 0x4d, 0x41, 0x58, 0x5f, 0x4e, 0x4f, 0x54,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d,
	0x5f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x53, 0x10, 0x05, 0x12, 0x31, 0x0a,
	0x2c, 0x4d, 0x41, 0x58, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55,
	0x54, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48, 0x10, 0x80, 0x02,
	0x12, 0x33, 0x0a, 0x2e, 0x4d, 0x41, 0x58, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x41, 0x54, 0x54, 0x52,
	0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47,
	0x54, 0x48, 0x10, 0x80, 0x08, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x41, 0x42,
	0x45, 0x4c, 0x53, 0x5f, 0x45, 0x4e, 0x54, 0x52, 0x49, 0x45, 0x53, 0x5f, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x40, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c,
	0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47,
	0x54, 0x48, 0x10, 0x3f, 0x12, 0x1f, 0x0a, 0x1a, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x42, 0x59, 0x54,
	0x45, 0x53, 0x10, 0x80, 0x01, 0x12, 0x2e, 0x0a, 0x29, 0x4d, 0x41, 0x58, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x53, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45,
	0x53, 0x54, 0x10, 0xe8, 0x07, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x5f, 0x54,
	0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x44,
	0x41, 0x59, 0x53, 0x10, 0x0e, 0x1a, 0x02, 0x10, 0x01, 0x22, 0xe8, 0x1b, 0x0a, 0x06, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x09, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x4d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x2b,
	0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x38, 0x0a, 0x03, 0x61,
	0x63, 0x6c, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x52, 0x03, 0x61, 0x63, 0x6c, 0x12, 0x54, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x41, 0x0a, 0x09, 0x6c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x32, 0x0a, 0x04, 0x63, 0x6f, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x43, 0x6f, 0x72, 0x73, 0x52, 0x04,
	0x63, 0x6f, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x61, 0x73, 0x65, 0x64, 0x48, 0x6f, 0x6c, 0x64, 0x12,
	0x3d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3b,
	0x0a, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69,
	0x74, 0x65, 0x52, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x12, 0x3b, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x33,
	0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x12, 0x44, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x07, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x54, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x52, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x72, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x42, 0x0a, 0x0a,
	0x69, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x49, 0x61, 0x6d, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x69, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x28, 0x0a, 0x0d, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x7a, 0x6f,
	0x6e, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x1a,
	0x30, 0x0a, 0x07, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x79,
	0x73, 0x1a, 0x87, 0x01, 0x0a, 0x04, 0x43, 0x6f, 0x72, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61,
	0x78, 0x41, 0x67, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x1a, 0x5c, 0x0a, 0x0a, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0f, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0d, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x1a, 0xbf, 0x03, 0x0a, 0x09, 0x49, 0x61,
	0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1b, 0x75, 0x6e, 0x69, 0x66, 0x6f,
	0x72, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x49, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x55, 0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x18, 0x75, 0x6e, 0x69, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x12, 0x74, 0x0a, 0x18, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x2e, 0x49, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x16, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x50, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x6d, 0x0a, 0x18, 0x55, 0x6e,
	0x69, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x37, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x16, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x24, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x41, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x52, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x44, 0x10, 0x01, 0x1a, 0xfa, 0x06, 0x0a, 0x09,
	0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x72, 0x75, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x1a, 0xae, 0x06, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x47, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65,
	0x63, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c,
	0x65, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x41, 0x0a, 0x06, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x1a, 0xc7,
	0x04, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x61, 0x67, 0x65, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07,
	0x61, 0x67, 0x65, 0x44, 0x61, 0x79, 0x73, 0x12, 0x4a, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6c, 0x69, 0x76, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x69, 0x73, 0x4c, 0x69, 0x76, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x6e, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6e,
	0x75, 0x6d, 0x4e, 0x65, 0x77, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x32, 0x0a, 0x15, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x33, 0x0a, 0x16,
	0x64, 0x61, 0x79, 0x73, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x64, 0x61,
	0x79, 0x73, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x51, 0x0a, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x14,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x73, 0x69, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x64, 0x61, 0x79, 0x73, 0x53, 0x69,
	0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x59, 0x0a, 0x1b, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x18, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x69, 0x73, 0x5f, 0x6c, 0x69, 0x76, 0x65, 0x1a, 0x54, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f, 0x67, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c,
	0x6f, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x9c,
	0x01, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x41, 0x0a, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x6c, 0x6f, 0x63, 0x6b,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x4c, 0x6f, 0x63, 0x6b,
	0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0x26, 0x0a,
	0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x59, 0x0a, 0x07, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65,
	0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x69, 0x6e,
	0x50, 0x61, 0x67, 0x65, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x6f,
	0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x67, 0x65,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x47, 0xea, 0x41, 0x44,
	0x0a, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x23, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x7d, 0x22, 0xdf, 0x01, 0x0a, 0x13, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04,
	0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x12, 0x41, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x65, 0x61, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x22, 0x53, 0x0a, 0x0f, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x07, 0x48, 0x00, 0x52, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x88, 0x01, 0x01,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x22, 0x54, 0x0a, 0x0f, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x1b,
	0x0a, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x07, 0x48, 0x00,
	0x52, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x08, 0x6d,
	0x64, 0x35, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x6d,
	0x64, 0x35, 0x48, 0x61, 0x73, 0x68, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63, 0x72, 0x63, 0x33, 0x32,
	0x63, 0x22, 0xc7, 0x0c, 0x0a, 0x06, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x0e, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x2f, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x38, 0x0a, 0x03, 0x61, 0x63, 0x6c, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x03, 0x61, 0x63, 0x6c, 0x12,
	0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x45, 0x0a, 0x09, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x5a, 0x0a, 0x19, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x72, 0x79, 0x5f, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x74,
	0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x6c, 0x64, 0x12, 0x4e, 0x0a, 0x15,
	0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x13, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x2d, 0x0a, 0x10, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64,
	0x5f, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x42, 0x61, 0x73, 0x65, 0x64, 0x48, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x33, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x5d, 0x0a, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x19, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d,
	0x65, 0x1a, 0x66, 0x0a, 0x12, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x14, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xdf, 0x01, 0x0a, 0x13,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x41, 0x0a, 0x0c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x22, 0x48, 0x0a,
	0x0b, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x12, 0x25, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x65, 0x61, 0x6d, 0x22, 0x3c, 0x0a, 0x05, 0x4f, 0x77, 0x6e, 0x65, 0x72,
	0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x22, 0x5f, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65,
	0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x27, 0x0a,
	0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x2a, 0xff, 0x01, 0x0a, 0x13, 0x50, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x25,
	0x0a, 0x21, 0x50, 0x52, 0x45, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f,
	0x41, 0x43, 0x4c, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x45,
	0x44, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x4f, 0x42, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4f, 0x57,
	0x4e, 0x45, 0x52, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c,
	0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c,
	0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41,
	0x43, 0x4c, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a,
	0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16,
	0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x43, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x06, 0x32, 0x93, 0x06, 0x0a, 0x07, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x12, 0x88, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x2b, 0xda, 0x41, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2c, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0xda, 0x41, 0x18, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2c, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x2c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x30, 0x01, 0x12,
	0x60, 0x0a, 0x0b, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28,
	0x01, 0x12, 0x76, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61,
	0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x79, 0x0a, 0x10, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x0c, 0xda, 0x41, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x69, 0x64, 0x1a, 0xa7, 0x02, 0xca, 0x41, 0x16, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x8a, 0x02, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x42, 0xdc,
	0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x42, 0x0c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x32, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f,
	0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73,
	0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storage_v2_storage_proto_rawDescOnce sync.Once
	file_google_storage_v2_storage_proto_rawDescData = file_google_storage_v2_storage_proto_rawDesc
)

func file_google_storage_v2_storage_proto_rawDescGZIP() []byte {
	file_google_storage_v2_storage_proto_rawDescOnce.Do(func() {
		file_google_storage_v2_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storage_v2_storage_proto_rawDescData)
	})
	return file_google_storage_v2_storage_proto_rawDescData
}

var file_google_storage_v2_storage_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_storage_v2_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_google_storage_v2_storage_proto_goTypes = []interface{}{
	(PredefinedObjectAcl)(0),                          // 0: google.storage.v2.PredefinedObjectAcl
	(ServiceConstants_Values)(0),                      // 1: google.storage.v2.ServiceConstants.Values
	(Bucket_IamConfig_PublicAccessPrevention)(0),      // 2: google.storage.v2.Bucket.IamConfig.PublicAccessPrevention
	(*ReadObjectRequest)(nil),                         // 3: google.storage.v2.ReadObjectRequest
	(*ReadObjectResponse)(nil),                        // 4: google.storage.v2.ReadObjectResponse
	(*WriteObjectSpec)(nil),                           // 5: google.storage.v2.WriteObjectSpec
	(*WriteObjectRequest)(nil),                        // 6: google.storage.v2.WriteObjectRequest
	(*WriteObjectResponse)(nil),                       // 7: google.storage.v2.WriteObjectResponse
	(*QueryWriteStatusRequest)(nil),                   // 8: google.storage.v2.QueryWriteStatusRequest
	(*QueryWriteStatusResponse)(nil),                  // 9: google.storage.v2.QueryWriteStatusResponse
	(*StartResumableWriteRequest)(nil),                // 10: google.storage.v2.StartResumableWriteRequest
	(*StartResumableWriteResponse)(nil),               // 11: google.storage.v2.StartResumableWriteResponse
	(*CommonObjectRequestParams)(nil),                 // 12: google.storage.v2.CommonObjectRequestParams
	(*CommonRequestParams)(nil),                       // 13: google.storage.v2.CommonRequestParams
	(*ServiceConstants)(nil),                          // 14: google.storage.v2.ServiceConstants
	(*Bucket)(nil),                                    // 15: google.storage.v2.Bucket
	(*BucketAccessControl)(nil),                       // 16: google.storage.v2.BucketAccessControl
	(*ChecksummedData)(nil),                           // 17: google.storage.v2.ChecksummedData
	(*ObjectChecksums)(nil),                           // 18: google.storage.v2.ObjectChecksums
	(*Object)(nil),                                    // 19: google.storage.v2.Object
	(*ObjectAccessControl)(nil),                       // 20: google.storage.v2.ObjectAccessControl
	(*ProjectTeam)(nil),                               // 21: google.storage.v2.ProjectTeam
	(*Owner)(nil),                                     // 22: google.storage.v2.Owner
	(*ContentRange)(nil),                              // 23: google.storage.v2.ContentRange
	(*Bucket_Billing)(nil),                            // 24: google.storage.v2.Bucket.Billing
	(*Bucket_Cors)(nil),                               // 25: google.storage.v2.Bucket.Cors
	(*Bucket_Encryption)(nil),                         // 26: google.storage.v2.Bucket.Encryption
	(*Bucket_IamConfig)(nil),                          // 27: google.storage.v2.Bucket.IamConfig
	(*Bucket_Lifecycle)(nil),                          // 28: google.storage.v2.Bucket.Lifecycle
	(*Bucket_Logging)(nil),                            // 29: google.storage.v2.Bucket.Logging
	(*Bucket_RetentionPolicy)(nil),                    // 30: google.storage.v2.Bucket.RetentionPolicy
	(*Bucket_Versioning)(nil),                         // 31: google.storage.v2.Bucket.Versioning
	(*Bucket_Website)(nil),                            // 32: google.storage.v2.Bucket.Website
	nil,                                               // 33: google.storage.v2.Bucket.LabelsEntry
	(*Bucket_IamConfig_UniformBucketLevelAccess)(nil), // 34: google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
	(*Bucket_Lifecycle_Rule)(nil),                     // 35: google.storage.v2.Bucket.Lifecycle.Rule
	(*Bucket_Lifecycle_Rule_Action)(nil),              // 36: google.storage.v2.Bucket.Lifecycle.Rule.Action
	(*Bucket_Lifecycle_Rule_Condition)(nil),           // 37: google.storage.v2.Bucket.Lifecycle.Rule.Condition
	(*Object_CustomerEncryption)(nil),                 // 38: google.storage.v2.Object.CustomerEncryption
	nil,                                               // 39: google.storage.v2.Object.MetadataEntry
	(*fieldmaskpb.FieldMask)(nil),                     // 40: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                     // 41: google.protobuf.Timestamp
}
var file_google_storage_v2_storage_proto_depIdxs = []int32{
	12, // 0: google.storage.v2.ReadObjectRequest.common_object_request_params:type_name -> google.storage.v2.CommonObjectRequestParams
	13, // 1: google.storage.v2.ReadObjectRequest.common_request_params:type_name -> google.storage.v2.CommonRequestParams
	40, // 2: google.storage.v2.ReadObjectRequest.read_mask:type_name -> google.protobuf.FieldMask
	17, // 3: google.storage.v2.ReadObjectResponse.checksummed_data:type_name -> google.storage.v2.ChecksummedData
	18, // 4: google.storage.v2.ReadObjectResponse.object_checksums:type_name -> google.storage.v2.ObjectChecksums
	23, // 5: google.storage.v2.ReadObjectResponse.content_range:type_name -> google.storage.v2.ContentRange
	19, // 6: google.storage.v2.ReadObjectResponse.metadata:type_name -> google.storage.v2.Object
	19, // 7: google.storage.v2.WriteObjectSpec.resource:type_name -> google.storage.v2.Object
	0,  // 8: google.storage.v2.WriteObjectSpec.predefined_acl:type_name -> google.storage.v2.PredefinedObjectAcl
	5,  // 9: google.storage.v2.WriteObjectRequest.write_object_spec:type_name -> google.storage.v2.WriteObjectSpec
	17, // 10: google.storage.v2.WriteObjectRequest.checksummed_data:type_name -> google.storage.v2.ChecksummedData
	18, // 11: google.storage.v2.WriteObjectRequest.object_checksums:type_name -> google.storage.v2.ObjectChecksums
	12, // 12: google.storage.v2.WriteObjectRequest.common_object_request_params:type_name -> google.storage.v2.CommonObjectRequestParams
	13, // 13: google.storage.v2.WriteObjectRequest.common_request_params:type_name -> google.storage.v2.CommonRequestParams
	19, // 14: google.storage.v2.WriteObjectResponse.resource:type_name -> google.storage.v2.Object
	12, // 15: google.storage.v2.QueryWriteStatusRequest.common_object_request_params:type_name -> google.storage.v2.CommonObjectRequestParams
	13, // 16: google.storage.v2.QueryWriteStatusRequest.common_request_params:type_name -> google.storage.v2.CommonRequestParams
	19, // 17: google.storage.v2.QueryWriteStatusResponse.resource:type_name -> google.storage.v2.Object
	5,  // 18: google.storage.v2.StartResumableWriteRequest.write_object_spec:type_name -> google.storage.v2.WriteObjectSpec
	12, // 19: google.storage.v2.StartResumableWriteRequest.common_object_request_params:type_name -> google.storage.v2.CommonObjectRequestParams
	13, // 20: google.storage.v2.StartResumableWriteRequest.common_request_params:type_name -> google.storage.v2.CommonRequestParams
	16, // 21: google.storage.v2.Bucket.acl:type_name -> google.storage.v2.BucketAccessControl
	20, // 22: google.storage.v2.Bucket.default_object_acl:type_name -> google.storage.v2.ObjectAccessControl
	28, // 23: google.storage.v2.Bucket.lifecycle:type_name -> google.storage.v2.Bucket.Lifecycle
	41, // 24: google.storage.v2.Bucket.create_time:type_name -> google.protobuf.Timestamp
	25, // 25: google.storage.v2.Bucket.cors:type_name -> google.storage.v2.Bucket.Cors
	41, // 26: google.storage.v2.Bucket.update_time:type_name -> google.protobuf.Timestamp
	33, // 27: google.storage.v2.Bucket.labels:type_name -> google.storage.v2.Bucket.LabelsEntry
	32, // 28: google.storage.v2.Bucket.website:type_name -> google.storage.v2.Bucket.Website
	31, // 29: google.storage.v2.Bucket.versioning:type_name -> google.storage.v2.Bucket.Versioning
	29, // 30: google.storage.v2.Bucket.logging:type_name -> google.storage.v2.Bucket.Logging
	22, // 31: google.storage.v2.Bucket.owner:type_name -> google.storage.v2.Owner
	26, // 32: google.storage.v2.Bucket.encryption:type_name -> google.storage.v2.Bucket.Encryption
	24, // 33: google.storage.v2.Bucket.billing:type_name -> google.storage.v2.Bucket.Billing
	30, // 34: google.storage.v2.Bucket.retention_policy:type_name -> google.storage.v2.Bucket.RetentionPolicy
	27, // 35: google.storage.v2.Bucket.iam_config:type_name -> google.storage.v2.Bucket.IamConfig
	21, // 36: google.storage.v2.BucketAccessControl.project_team:type_name -> google.storage.v2.ProjectTeam
	20, // 37: google.storage.v2.Object.acl:type_name -> google.storage.v2.ObjectAccessControl
	41, // 38: google.storage.v2.Object.delete_time:type_name -> google.protobuf.Timestamp
	41, // 39: google.storage.v2.Object.create_time:type_name -> google.protobuf.Timestamp
	18, // 40: google.storage.v2.Object.checksums:type_name -> google.storage.v2.ObjectChecksums
	41, // 41: google.storage.v2.Object.update_time:type_name -> google.protobuf.Timestamp
	41, // 42: google.storage.v2.Object.update_storage_class_time:type_name -> google.protobuf.Timestamp
	41, // 43: google.storage.v2.Object.retention_expire_time:type_name -> google.protobuf.Timestamp
	39, // 44: google.storage.v2.Object.metadata:type_name -> google.storage.v2.Object.MetadataEntry
	22, // 45: google.storage.v2.Object.owner:type_name -> google.storage.v2.Owner
	38, // 46: google.storage.v2.Object.customer_encryption:type_name -> google.storage.v2.Object.CustomerEncryption
	41, // 47: google.storage.v2.Object.custom_time:type_name -> google.protobuf.Timestamp
	21, // 48: google.storage.v2.ObjectAccessControl.project_team:type_name -> google.storage.v2.ProjectTeam
	34, // 49: google.storage.v2.Bucket.IamConfig.uniform_bucket_level_access:type_name -> google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
	2,  // 50: google.storage.v2.Bucket.IamConfig.public_access_prevention:type_name -> google.storage.v2.Bucket.IamConfig.PublicAccessPrevention
	35, // 51: google.storage.v2.Bucket.Lifecycle.rule:type_name -> google.storage.v2.Bucket.Lifecycle.Rule
	41, // 52: google.storage.v2.Bucket.RetentionPolicy.effective_time:type_name -> google.protobuf.Timestamp
	41, // 53: google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.lock_time:type_name -> google.protobuf.Timestamp
	36, // 54: google.storage.v2.Bucket.Lifecycle.Rule.action:type_name -> google.storage.v2.Bucket.Lifecycle.Rule.Action
	37, // 55: google.storage.v2.Bucket.Lifecycle.Rule.condition:type_name -> google.storage.v2.Bucket.Lifecycle.Rule.Condition
	41, // 56: google.storage.v2.Bucket.Lifecycle.Rule.Condition.created_before_time:type_name -> google.protobuf.Timestamp
	41, // 57: google.storage.v2.Bucket.Lifecycle.Rule.Condition.custom_time_before_time:type_name -> google.protobuf.Timestamp
	41, // 58: google.storage.v2.Bucket.Lifecycle.Rule.Condition.noncurrent_time_before_time:type_name -> google.protobuf.Timestamp
	3,  // 59: google.storage.v2.Storage.ReadObject:input_type -> google.storage.v2.ReadObjectRequest
	6,  // 60: google.storage.v2.Storage.WriteObject:input_type -> google.storage.v2.WriteObjectRequest
	10, // 61: google.storage.v2.Storage.StartResumableWrite:input_type -> google.storage.v2.StartResumableWriteRequest
	8,  // 62: google.storage.v2.Storage.QueryWriteStatus:input_type -> google.storage.v2.QueryWriteStatusRequest
	4,  // 63: google.storage.v2.Storage.ReadObject:output_type -> google.storage.v2.ReadObjectResponse
	7,  // 64: google.storage.v2.Storage.WriteObject:output_type -> google.storage.v2.WriteObjectResponse
	11, // 65: google.storage.v2.Storage.StartResumableWrite:output_type -> google.storage.v2.StartResumableWriteResponse
	9,  // 66: google.storage.v2.Storage.QueryWriteStatus:output_type -> google.storage.v2.QueryWriteStatusResponse
	63, // [63:67] is the sub-list for method output_type
	59, // [59:63] is the sub-list for method input_type
	59, // [59:59] is the sub-list for extension type_name
	59, // [59:59] is the sub-list for extension extendee
	0,  // [0:59] is the sub-list for field type_name
}

func init() { file_google_storage_v2_storage_proto_init() }
func file_google_storage_v2_storage_proto_init() {
	if File_google_storage_v2_storage_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_storage_v2_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadObjectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteObjectSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteObjectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWriteStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWriteStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartResumableWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartResumableWriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonObjectRequestParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonRequestParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConstants); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BucketAccessControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChecksummedData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectChecksums); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Object); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectAccessControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectTeam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Owner); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Billing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Cors); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Encryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_IamConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Logging); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_RetentionPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Versioning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Website); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_IamConfig_UniformBucketLevelAccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle_Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle_Rule_Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle_Rule_Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v2_storage_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Object_CustomerEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_storage_v2_storage_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_storage_v2_storage_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_google_storage_v2_storage_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*WriteObjectRequest_UploadId)(nil),
		(*WriteObjectRequest_WriteObjectSpec)(nil),
		(*WriteObjectRequest_ChecksummedData)(nil),
	}
	file_google_storage_v2_storage_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*WriteObjectResponse_CommittedSize)(nil),
		(*WriteObjectResponse_Resource)(nil),
	}
	file_google_storage_v2_storage_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*QueryWriteStatusResponse_CommittedSize)(nil),
		(*QueryWriteStatusResponse_Resource)(nil),
	}
	file_google_storage_v2_storage_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_storage_v2_storage_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_google_storage_v2_storage_proto_msgTypes[16].OneofWrappers = []interface{}{}
	file_google_storage_v2_storage_proto_msgTypes[34].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storage_v2_storage_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_storage_v2_storage_proto_goTypes,
		DependencyIndexes: file_google_storage_v2_storage_proto_depIdxs,
		EnumInfos:         file_google_storage_v2_storage_proto_enumTypes,
		MessageInfos:      file_google_storage_v2_storage_proto_msgTypes,
	}.Build()
	File_google_storage_v2_storage_proto = out.File
	file_google_storage_v2_storage_proto_rawDesc = nil
	file_google_storage_v2_storage_proto_goTypes = nil
	file_google_storage_v2_storage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageClient interface {
	// Reads an object's data.
	ReadObject(ctx context.Context, in *ReadObjectRequest, opts ...grpc.CallOption) (Storage_ReadObjectClient, error)
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `WriteObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()` and provide that method an `WriteObjectSpec.`
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `Create`. If there is an error or the connection is
	// broken during the resumable `Create()`, the client should check the status
	// of the `Create()` by calling `QueryWriteStatus()` and continue writing from
	// the returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// The service will not view the object as complete until the client has
	// sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` will cause an error. The client **should** check the response it
	// receives to determine how much data the service was able to commit and
	// whether the service views the object as complete.
	WriteObject(ctx context.Context, opts ...grpc.CallOption) (Storage_WriteObjectClient, error)
	// Starts a resumable write. How long the write operation remains valid, and
	// what happens when the write operation becomes invalid, are
	// service-dependent.
	StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error)
	// Determines the `committed_size` for an object that is being written, which
	// can then be used as the `write_offset` for the next `Write()` call.
	//
	// If the object does not exist (i.e., the object has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this object. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error)
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) ReadObject(ctx context.Context, in *ReadObjectRequest, opts ...grpc.CallOption) (Storage_ReadObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[0], "/google.storage.v2.Storage/ReadObject", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageReadObjectClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Storage_ReadObjectClient interface {
	Recv() (*ReadObjectResponse, error)
	grpc.ClientStream
}

type storageReadObjectClient struct {
	grpc.ClientStream
}

func (x *storageReadObjectClient) Recv() (*ReadObjectResponse, error) {
	m := new(ReadObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) WriteObject(ctx context.Context, opts ...grpc.CallOption) (Storage_WriteObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[1], "/google.storage.v2.Storage/WriteObject", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageWriteObjectClient{stream}
	return x, nil
}

type Storage_WriteObjectClient interface {
	Send(*WriteObjectRequest) error
	CloseAndRecv() (*WriteObjectResponse, error)
	grpc.ClientStream
}

type storageWriteObjectClient struct {
	grpc.ClientStream
}

func (x *storageWriteObjectClient) Send(m *WriteObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageWriteObjectClient) CloseAndRecv() (*WriteObjectResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(WriteObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error) {
	out := new(StartResumableWriteResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v2.Storage/StartResumableWrite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error) {
	out := new(QueryWriteStatusResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v2.Storage/QueryWriteStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageServer is the server API for Storage service.
type StorageServer interface {
	// Reads an object's data.
	ReadObject(*ReadObjectRequest, Storage_ReadObjectServer) error
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `WriteObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()` and provide that method an `WriteObjectSpec.`
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `Create`. If there is an error or the connection is
	// broken during the resumable `Create()`, the client should check the status
	// of the `Create()` by calling `QueryWriteStatus()` and continue writing from
	// the returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// The service will not view the object as complete until the client has
	// sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` will cause an error. The client **should** check the response it
	// receives to determine how much data the service was able to commit and
	// whether the service views the object as complete.
	WriteObject(Storage_WriteObjectServer) error
	// Starts a resumable write. How long the write operation remains valid, and
	// what happens when the write operation becomes invalid, are
	// service-dependent.
	StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error)
	// Determines the `committed_size` for an object that is being written, which
	// can then be used as the `write_offset` for the next `Write()` call.
	//
	// If the object does not exist (i.e., the object has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this object. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error)
}

// UnimplementedStorageServer can be embedded to have forward compatible implementations.
type UnimplementedStorageServer struct {
}

func (*UnimplementedStorageServer) ReadObject(*ReadObjectRequest, Storage_ReadObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadObject not implemented")
}
func (*UnimplementedStorageServer) WriteObject(Storage_WriteObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method WriteObject not implemented")
}
func (*UnimplementedStorageServer) StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartResumableWrite not implemented")
}
func (*UnimplementedStorageServer) QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWriteStatus not implemented")
}

func RegisterStorageServer(s *grpc.Server, srv StorageServer) {
	s.RegisterService(&_Storage_serviceDesc, srv)
}

func _Storage_ReadObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadObjectRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StorageServer).ReadObject(m, &storageReadObjectServer{stream})
}

type Storage_ReadObjectServer interface {
	Send(*ReadObjectResponse) error
	grpc.ServerStream
}

type storageReadObjectServer struct {
	grpc.ServerStream
}

func (x *storageReadObjectServer) Send(m *ReadObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Storage_WriteObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageServer).WriteObject(&storageWriteObjectServer{stream})
}

type Storage_WriteObjectServer interface {
	SendAndClose(*WriteObjectResponse) error
	Recv() (*WriteObjectRequest, error)
	grpc.ServerStream
}

type storageWriteObjectServer struct {
	grpc.ServerStream
}

func (x *storageWriteObjectServer) SendAndClose(m *WriteObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageWriteObjectServer) Recv() (*WriteObjectRequest, error) {
	m := new(WriteObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Storage_StartResumableWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartResumableWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).StartResumableWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v2.Storage/StartResumableWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).StartResumableWrite(ctx, req.(*StartResumableWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_QueryWriteStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWriteStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).QueryWriteStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v2.Storage/QueryWriteStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).QueryWriteStatus(ctx, req.(*QueryWriteStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Storage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.storage.v2.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartResumableWrite",
			Handler:    _Storage_StartResumableWrite_Handler,
		},
		{
			MethodName: "QueryWriteStatus",
			Handler:    _Storage_QueryWriteStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadObject",
			Handler:       _Storage_ReadObject_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "WriteObject",
			Handler:       _Storage_WriteObject_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "google/storage/v2/storage.proto",
}
