Frontend stuff
==============

A continuously expanded list of framework/libraries and tools I used/want to use when building things on the web. Mostly Javascript stuff.

## Table of Contents
- [CSS/UI Frameworks](#cssui-frameworks)
- [Frontend Frameworks/UI Component Libraries](#frontend-frameworks-ui-component-libraries)
- [Allrounder](#allrounder-jquery-like) (jQuery like)
- [Charts](#charts)
- [Maps](#maps)
- [Tables](#tables)
- [Selects](#selects)
- [Loaders](#loaders)
- [UI Elements](#ui-elements)
- [Content Slider/Carousels](#content-slidercarousels)
- [Typography/Text](#typographytext)
- [Video](#video)
- [Audio](#audio)
- [Canvas and SVG](#canvas-and-svg)
- [3D/WebGL Frameworks](#3dwebgl-frameworks)
- [Image Processing](#image-processing)
- [Scrolling](#scrolling)
- [Touch Gestures](#touch-gestures)
- [Animations](#animations)
- [Templating](#templating)
- [HTTP Requests](#http-requests)
- [Events](#events)
- [Icons](#icons)
- [Colors](#colors)
- [Databases/Storage](#databasesstorage)
- [Validation](#validation)
- [Dates](#dates)
- [Internationalization](#internationalization)
- [Numbers & Currencies](#numbers--currencies)
- [Statistics & data analysis](#statistics--data-analysis)
- [Module Loaders](#module-loaders)
- [Lazy Loading](#lazy-loading)
- [Neural Networks](#neural-networks)
- [Social](#social)
- [Utility Libraries](#utility-libraries)
- [General](#general)

### CSS/UI Frameworks
- [base](http://matthewhartman.github.io/base/) - Responsive CSS framework with IE7+ support
- [BASSCSS](http://www.basscss.com/) - Low-level CSS toolkit
- [bootflat](http://bootflat.github.io/index.html) - Bootstrap with a flat design theme
- [Bootswatch](https://github.com/thomaspark/bootswatch) - A collection of themes for Bootstrap
- [bulma](http://bulma.io/) - CSS framework based on Flexbox
- [cardinal](http://cardinalcss.com/) - Cardinal is a small mobile first CSS framework
- [caramel](http://caramel.kurisubrooks.com/) - A simple, beautiful, responsive, modern CSS framework
- [corpus](https://github.com/jamiewilson/corpus) - A collection of CSS things
- [HTML Starterkit](http://zitrusfrisch.com/html-starterkit/) - HTML5 template to kick off your responsive websites
- [kube](http://imperavi.com/kube/) - Minimalistic Web framework
- [Material Design Lite](http://www.getmdl.io/) - Material Design Lite Components in HTML/CSS/JS
- [materialize](http://materializecss.com/) - A modern responsive front-end framework based on Material Design
- [Metro UI](https://metroui.org.ua/) - A front-end framework for developing website in Windows Metro Style
- [milligram](http://milligram.github.io/) - Minimal setup of styles for a fast starting point.
- [mini.css](https://chalarangelo.github.io/mini.css/) - A minimal, responsive, style-agnostic CSS framework/toolkit
- [mui](https://www.muicss.com) - A Lightweight HTML/CSS/JS Framework implementing Material Design
- [paperCSS](https://www.getpapercss.com/) - The Less Formal CSS Framework
- [papier](http://gugel.io/papier/) - Material design like minimal CSS framework
- [pavilion](http://www.pavilion.io/) - Unopinionated CSS framework
- [picnicss](http://picnicss.com/) - Lightweight UI library
- [pure](http://purecss.io/) - A set of small, responsive CSS modules
- [semantic-ui](http://semantic-ui.com/) - UI Kit with lots of themes and elements
- [skeleton](http://getskeleton.com/) - A dead simple, responsive boilerplate
- [tachyons](http://tachyons.io/) - Modular UI framework
- [tacit](https://github.com/yegor256/tacit) - CSS framework without classes
- [uikit](http://getuikit.com/index.html) - A lightweight and modular front-end framework
- [wing](https://github.com/KingPixil/wing/) - Minimal CSS framework

**[ back to top](#table-of-contents)**

### Frontend Frameworks/ Ui Component Libraries
- [Angular](https://angularjs.org/) - HTML enhanced for web apps
- [Aurelia](http://aurelia.io/) - UI framework for the browser, mobile or desktop apps
- [choo](https://github.com/yoshuawuyts/choo) - Isomorphic, single state, functional frontend framework
- [deku](https://github.com/anthonyshort/deku) - Library for rendering interfaces using pure functions and virtual DOM
- [DisplayJS](https://github.com/arguiot/DisplayJS) - A simple JavaScript framework for building ambitious UIs.
- [inferno](https://github.com/trueadm/inferno) - Isomorphic library for building high-performance user interfaces
- [jsblocks](https://github.com/astoilkov/jsblocks) - MV-ish framework for single page apps
- [mercury](https://github.com/Raynos/mercury) - Modular frontend framework
- [mithril](https://github.com/lhorie/mithril.js/) - Client-side MVC framework
- [Moon](http://moonjs.ga/) - Minimal UI library 
- [preact](https://github.com/developit/preact) - React ES6 API + Components & Virtual DOM
- [React](https://facebook.github.io/react/) - Library for building user interfaces
- [RE:DOM](https://github.com/pakastin/redom) - Library for creating user interfaces
- [react-lite](https://github.com/Lucifier129/react-lite) - Implementation of React that optimizes for small script size
- [riot](http://riotjs.com/) - User interface micro-library
- [skatejs](https://github.com/skatejs/skatejs) - Web component library
- [svelte](https://github.com/sveltejs/svelte) - The magical disappearing UI framework
- [vue](https://github.com/vuejs/vue) - Library for building web interfaces

**[ back to top](#table-of-contents)**

### Allrounder (jQuery like)
- [bliss](http://blissfuljs.com/) - A collection of helpers and light syntactic sugar over Vanilla JS
- [cash](https://github.com/kenwheeler/cash) - Library that provides jQuery style syntax to wrap modern Vanilla JS features
- [jQuery](https://jquery.com/) - Feature-rich JavaScript library
- [NodeList.js](https://github.com/eorroe/NodeList.js) - Use the Native DOM APIs as easily as jQuery
- [Selector](https://github.com/Websilk/Selector) - Lightweight library used as a replacement for jQuery
- [umbrella](https://github.com/umbrellajs/umbrella) - DOM, Event and AJAX library
- [zeptojs](http://zeptojs.com/) - Library with a largely jQuery-compatible API

**[ back to top](#table-of-contents)**

### Charts
- [chartist](http://gionkunz.github.io/chartist-js/) - Simple responsive charts
- [charts](https://github.com/frappe/charts) - SVG Charts with zero dependencies
- [chartjs](http://www.chartjs.org/) - Simple, clean and engaging charts for designers and developers
- [Cytoscape.js](http://js.cytoscape.org/) - Graph theory / network library for analysis and visualisation
- [c3](http://c3js.org/) - D3-based reusable chart library
- [dc](http://dc-js.github.io/dc.js/) - For heavy amounts of data
- [dimple](http://dimplejs.org) - An object-oriented API for business analytics powered by d3
- [D3xter](https://github.com/NathanEpstein/D3xter) - Straight forward plotting built on D3
- [ECharts](http://echarts.baidu.com/index-en.html) - Charting library and interactive data visualization tool
- [epoch](http://epochjs.github.io/epoch) - A general purpose, real-time visualization library
- [flowchart.js](http://adrai.github.io/flowchart.js) - Draws flow charts from textual representation of the diagram
- [ggraph](https://github.com/pcbje/ggraph) - Graph visualization of big messy data
- [jsplumb](http://jsplumbtoolkit.com/) - Visual connectivity for webapps (flowcharts, sequence diagrams, etc)
- [metricsgraphics](http://metricsgraphicsjs.org/) - Optimized for visualizing time-series data
- [morrisjs](https://github.com/morrisjs/morris.js) - SVG charts based on jquery and Raphael
- [nvd3](http://nvd3.org/) - Re-usable charts and chart components for d3.js
- [peity](http://benpickles.github.io/peity/) - Progressive mini \<svg\> pie, donut, bar and line charts
- [sparkline](http://omnipotent.net/jquery.sparkline/) - Sparkline charts library
- [sparky](http://prag.ma/code/sparky/) - Sparkline charts library based on rapahel
- [taucharts](http://www.taucharts.com/) - Charts with a focus on design and flexibility
- [timesheet.js](https://sbstjn.github.io/timesheet.js/) - HTML5 & CSS3 time sheets
- [uvCharts](https://github.com/imaginea/uvCharts) - Simple, robust, extensible charting library built using d3
- [vis.js](http://visjs.org/) - A dynamic, browser based visualization library
- [VivaGraph](https://github.com/anvaka/VivaGraphJS) - Extensible graph drawing library
- [Z3d](https://github.com/NathanEpstein/Z3d) - 3d plots with three.js

**[ back to top](#table-of-contents)**

### Maps
- [Cesium](http://cesiumjs.org/) - Library for creating 3D globes and 2D maps in a web browser without a plugin
- [Kartograph](http://kartograph.org/) - Simple and lightweight framework for building interactive map applications without Google Maps
- [leaflet](http://leafletjs.com/) - Library for Mobile-Friendly Interactive Maps
- [leaflet plugins](http://leafletjs.com/plugins.html) - Notable Leaflet Plugins
- [leaflet topojson support](https://gist.github.com/rclark/5779673) - TopoJSON-aware Leaflet layer
- [Mapbox GL JS](https://www.mapbox.com/mapbox-gl-js/) - Interactive WebGL maps from vector tiles
- [mapmap.js](https://github.com/floledermann/mapmap.js) - A data-driven API for interactive thematic maps
- [mapsicon](https://github.com/djaiss/mapsicon) - Collection of maps for nearly every country in the world in PNG and SVG
- [osmbuildings](http://osmbuildings.org/) - Library for visualizing buildings as pseudo 3D objects on interactive maps
- [openlayers3](http://openlayers.org/) - Mapping library that supports different projections
- [planetary](http://planetaryjs.com/) - Interactive globes for the web
- [smallworld](http://mikefowler.me/smallworld.js/) - A small utility for generating a small world
- [Tangram](https://mapzen.com/products/tangram/) - WebGL based map renderer
- [topojson](https://github.com/mbostock/topojson) - An extension to GeoJSON that encodes topology
- [turf](http://turfjs.org/) - A modular geospatial engine

**[ back to top](#table-of-contents)**

### Tables
- [Clusterize.js](https://github.com/NeXTs/Clusterize.js) - Vanilla plugin to display large data sets
- [DataTables](http://www.datatables.net/) - jQuery plugin which adds sorting, paging and filtering abilities to plain HTML tables with minimal effort
- [dynatables](http://www.dynatable.com/) - Semantic and interactive table plugin using jQuery, HTML5, and JSON
- [handson table](http://handsontable.com/) - Minimalist Excel-like data grid editor
- [ListJS](http://www.listjs.com/) - Adds search, sort, filters and flexibility to plain HTML lists, tables, or anything
- [sortable](http://github.hubspot.com/sortable/docs/welcome/) - Makes tables sortable

**[ back to top](#table-of-contents)**

### Selects
- [awesomplete](https://leaverou.github.io/awesomplete/) - Lightweight autocomplete
- [chosen](https://harvesthq.github.io/chosen/) - Library for making long, unwieldy select boxes more friendly
- [select2](https://select2.github.io/) - JQuery based replacement for select boxes

**[ back to top](#table-of-contents)**

### Loaders
- [Loaders.css](https://github.com/ConnorAtherton/loaders.css) - Delightful, performance-focused pure css loading animations
- [MProgress.js](https://lightningtgc.github.io/MProgress.js/) - Google Material Design Progress Linear bar
- [NProgress](http://ricostacruz.com/nprogress/) - Slim progress bars for Ajax'y applications. Inspired by Google, YouTube, and Medium
- [nanobar](https://github.com/jacoborus/nanobar/) - Lightweight progress bars without jQuery
- [PACE](http://github.hubspot.com/pace/docs/welcome/) - Automatic page load progress bar. Needs zero config. Easy themeable.
- [PleaseWait.js](https://pathgather.github.io/please-wait/) - A simple library to show your users a beautiful splash page while your application loads

**[ back to top](#table-of-contents)**

### UI Elements
- [button concepts](http://tympanus.net/Development/CreativeButtons/) - List of CSS button variations
- [countUp.js](https://inorganik.github.io/countUp.js/) - Count up or down animation effects for numbers
- [Flipside](http://lab.hakim.se/flipside/) - A button that seamlessly transitions from action to confirmation with flipping animation
- [Messenger.js](http://github.hubspot.com/messenger/) - Client-side growl-like notifications with actions and auto-retry.
- [nouislider](https://refreshless.com/nouislider/) - Range slider
- [Slideout.js](http://mango.github.io/slideout/) - A touch slideout navigation menu for mobile web apps
- [Sortable.js](http://rubaxa.github.io/Sortable/) - Reorderable drag-and-drop lists
- [SweetAlert](https://t4t5.github.io/sweetalert/) - An awesome replacement for JavaScript's alert
- [Toastr](http://codeseven.github.io/toastr/) - Simple toast notifications
- [vex](http://github.hubspot.com/vex/docs/welcome/) - A modern dialog library which is highly configurable and easy to style

**[ back to top](#table-of-contents)**

### Content Slider/Carousels
- [lory](http://meandmax.github.io/lory/) - Minimalistic slider written in vanilla JavaScript
- [ItemSlide.js](http://itemslide.github.io/) - Touch carousel (needs jquery)
- [Siema](https://pawelgrzybek.com/siema/) - Carousel with no dependencies
- [slick](http://kenwheeler.github.io/slick/) - Fully responsive carousel (needs zepto or jquery)
- [swipe](https://github.com/lyfeyaj/swipe) - Touch slider with React and Angular support
- [swiper](http://www.idangero.us/swiper/) - Slider with touch support

**[ back to top](#table-of-contents)**

### Typography/Text
- [bacon](http://baconforme.com/) - Wraps text around a Bézier curve or a line
- [bigfoot.js](http://www.bigfootjs.com/) - Responsive popover footnotes
- [dropcap.js](https://github.com/adobe-webplatform/dropcap.js) - CSS dropcaps
- [fitty](https://github.com/rikschennink/fitty) - Scales text so it fits to its parent container
- [flowtype](http://simplefocus.com/flowtype/) - Responsive typography
- [grande.js](https://github.com/mduvall/grande.js) - Library that implements features from Medium's editing experience
- [lining.js](https://github.com/zmmbreeze/lining.js) - A complete DOWN-TO-THE-LINE control for radical web typography
- [lettering](http://letteringjs.com/) - JQuery web typography plugin
- [pen](http://sofish.github.io/pen) - Editor with markdown support
- [Plumin.js](http://www.pluminjs.com/) - Create and manipulate fonts using javascript
- [shave](https://dollarshaveclub.github.io/shave/) - Plugin for truncating text within an html element
- [side-comments](http://aroc.github.io/side-comments-demo/) - Medium style comments
- [slabText](https://github.com/freqdec/slabText) - jQuery plugin for producing big, bold & responsive headlines
- [smart underline](https://eager.io/showcase/SmartUnderline/) - Descender-aware underlines for every browser
- [typeahead.js](http://twitter.github.com/typeahead.js) - Foundation for building robust typeaheads
- [Typeplate](http://typeplate.com/) - A typographic starter kit
- [Typeset.js](https://github.com/davidmerfield/typeset) - HTML pre-processor for web typography

**[ back to top](#table-of-contents)**

### Video
- [Fitvid](http://fitvidsjs.com/) - Responsive videos
- [medialementjs](http://mediaelementjs.com/) - Video and audio handling
- [Plyr](http://plyr.io/) - A simple HTML5 media player with custom controls and WebVTT captions
- [talkie](https://github.com/kiln/talkie) - Combines audio and animations
- [Videojs](http://www.videojs.com/) - Open source HTML5 video player

**[ back to top](#table-of-contents)**

### Audio
- [audio5js](https://github.com/zohararad/audio5js) - The HTML5 Audio Compatibility Layer
- [blip](http://jshanley.github.io/blip/) - Web Audio API wrapper
- [howler](http://howlerjs.com/) - Audio library
- [SoundCite](http://soundcite.knightlab.com/) - Inline audio player
- [soundjs](http://createjs.com/SoundJS) - Audio library + simple interface
- [timbre.js](http://mohayonao.github.io/timbre.js/) -Library for Objective Sound Programming
- [vexflow](http://www.vexflow.com/) - HTML5 Music Engraving
- [tone.js](https://github.com/Tonejs/Tone.js) - Framework for interactive music

**[ back to top](#table-of-contents)**

### Canvas and SVG
- [D3](http://d3js.org/) - A JavaScript visualization library for HTML and SVG
- [Easeljs](http://www.createjs.com/easeljs) - Library for building canvas based interactive 2D content
- [Fabric.js](http://fabricjs.com/) - Canvas Library, SVG-to-Canvas (& Canvas-to-SVG) Parser
- [GraphicsJS](http://www.graphicsjs.org/) - Graphics library with an intuitive API, based on SVG/VML technology
- [Konva](http://konvajs.github.io/) - Framework that extends the 2d context by enabling canvas interactivity
- [panzoom](https://github.com/anvaka/panzoom) - Pan and zoom SVG elements
- [Paper.js](http://paperjs.org/) - Canvas based vector graphics scripting framework
- [Paths.js](https://github.com/andreaferretti/paths-js) - Generate SVG paths for geometric shapes
- [pixi.js](http://www.pixijs.com/) - 2D WebGL rendering engine with Canvas fallback
- [p5js](http://p5js.org/) - Processing for Javascript
- [Raphael](http://raphaeljs.com/) - Library that simplify your work with vector graphics on the web
- [rune.js](http://runemadsen.github.io/rune.js/index.html) - A Library for programming graphic design systems with SVG
- [svg.js](https://github.com/wout/svg.js) - A Library for manipulating and animating SVG
- [two.js](https://jonobr1.github.io/two.js/) -  A two-dimensional drawing api
- [vizflow](https://github.com/vizflow/vizflow) - Interactive visualization engine

**[ back to top](#table-of-contents)**

### 3D/WebGL Frameworks
- [babylonJS](http://babylonjs.com/) - Framework for building 3D games with HTML5, WebGL and Web Audio
- [sceneJS](http://scenejs.org/) - WebGL-based 3D visualization engine
- [three.js](https://threejs.org/)- 3D Library which makes WebGL simpler
- [voxel.js](http://voxeljs.com/) - Voxel game building toolkit
- [WhitestormJS](https://whsjs.io/#/) - Framework for developing 3D web apps with physics

**[ back to top](#table-of-contents)**

### Image Processing
- [camanjs](http://camanjs.com/) - Combination of a simple-to-use interface with advanced and image/canvas editing techniques
- [grafijs](http://grafijs.org/) - Library with basic image processing functions
- [smartcrop](https://github.com/jwagner/smartcrop.js/) - Content aware image cropping

**[ back to top](#table-of-contents)**

### Scrolling
- [fracs](http://larsjung.de/jquery-fracs/) - Plugin to determine the visible fractions of HTML elements
- [headroom](http://wicky.nillia.ms/headroom.js/) - Hide your header until you need it
- [in-view](https://camwiegert.github.io/in-view) - Get notified when a element enters/exits the viewport
- [midnight.js](https://github.com/Aerolab/midnight.js) - Make your header looks great with the content below it as you scroll
- [moveTo](https://github.com/hsnaydd/moveTo) - Scroll animation library
- [scroll-scope.js](http://eiskis.net/scroll-scope/) - Keep parent element still when scrolling an element to its boundary
- [scrollme](http://scrollme.nckprsn.com/) - A jQuery plugin for adding simple scrolling effects to web pages
- [ScrollMagic](http://janpaepke.github.io/ScrollMagic/) - Library for scroll interactions
- [scrollMonitor](https://github.com/stutrek/scrollMonitor) - API to monitor elements as you scroll
- [scrollreveal](https://scrollrevealjs.org/) - Scroll animations for web and mobile browsers
- [ScrollToFixed](https://github.com/bigspotteddog/ScrollToFixed) - Used to fix elements on the page and move with the horizontal scroll
- [skrollr](https://github.com/Prinzhorn/skrollr) - Stand-alone parallax scrolling library for mobile and desktop
- [space.js](https://github.com/gopatrik/space.js) - A HTML-driven JavaScript-library for narrative 3D-scrolling
- [superscrollorama](https://github.com/johnpolacek/superscrollorama) - The jQuery plugin for supercool scroll animation
- [WOW](http://mynameismatthieu.com/WOW/) - Reveal CSS animation as you scroll down a page

**[ back to top](#table-of-contents)**

### Touch Gestures
- [AlloyFinger](https://github.com/AlloyTeam/AlloyFinger) - Multi-touch gestures library
- [Hammer.js](http://hammerjs.github.io/) - Add support for touch gestures and remove 300ms delay from clicks

**[ back to top](#table-of-contents)**

### Animations
- [animate.css](https://daneden.github.io/animate.css/) - A cross-browser library of CSS animations
- [Animate Plus](https://github.com/bendc/animateplus) - Tiny (2 KB minified and gzipped) animation library
- [Anime](http://anime-js.com/) - Anime is a flexible yet lightweight animation library
- [bounce.js](http://bouncejs.com/) - CSS3 powered animations
- [choreographer](https://github.com/christinecha/choreographer-js) - Library to take care of complicated css animations
- [Dynamics.js](http://dynamicsjs.com/) - Library to create physics-based CSS animations
- [GSAP](https://greensock.com/gsap) - Fast animation library
- [Hover.css](http://ianlunn.github.io/Hover/) - CSS3 Hover Effects
- [impulse](http://impulse.luster.io/) - Dynamic physics interactions for the mobile web
- [KUTE.js](http://thednp.github.io/kute.js/#) - animation engine, memory efficient & modular code
- [mojs](http://mojs.io/) - Motion for the web
- [popmotion](http://popmotion.io/) - Motion Engine. Use for animation, physics and input tracking.
- [rebound](http://facebook.github.io/rebound-js/examples/) - Library that models Spring dynamics for driving physical animations
- [repaintless](http://szynszyliszys.github.io/repaintless/)  - Animation library that consists of animations that don't cause reflows and repaints
- [semantic ui - transition](http://semantic-ui.com/modules/transition.html) - Simple CSS3 Animations and transitions
- [Sequence.js](https://github.com/IanLunn/Sequence/) - Responsive CSS animation framework
- [shifty](https://jeremyckahn.github.io/shifty/) - Tweening engine
- [snabbt](https://daniel-lundin.github.io/snabbt.js/) - Animations with JavaScript and CSS transforms
- [snapsvg](http://snapsvg.io/) - Library for animating and manipulating SVG's
- [tween.js](https://github.com/tweenjs/tween.js) - Tweening engine
- [velocity](http://velocityjs.org/) - Accelerated JavaScript animations
- [vivus](https://maxwellito.github.io/vivus/) - Vivus is a lightweight JavaScript class (with no dependencies) that allows you to animate SVGs, giving them the appearence of being drawn

**[ back to top](#table-of-contents)**

### Templating
- [dotjs](https://olado.github.io/doT/) - Fast templating engine
- [Handlebars](http://handlebarsjs.com/) - Minimal Templating on Steroids
- [Hogan](http://twitter.github.io/hogan.js/) - JavaScript templating
- [marko](http://markojs.com/) - Fast and lightweight HTML-based templating engine that compiles templates to CommonJS modules and supports streaming, async rendering, custom tags and a concise syntax
- [mustache](https://github.com/janl/mustache.js) - Minimal templating with {{mustaches}} in JavaScript
- [nunjucks](http://mozilla.github.io/nunjucks/) - A rich and powerful templating language
- [paperclip.js](http://paperclipjs.com/) - Reactive DOM template engine built for speed and extensibility
- [vdo](https://github.com/DylanPiercey/vdo) - Minimal JSX compatible html focused templating engine

**[ back to top](#table-of-contents)**

### HTTP Requests
- [aja](http://krampstudio.github.io/aja.js/) - Asynchronous JavaScript and JSON(P)
- [axios](https://github.com/mzabriskie/axios) - Promise based HTTP client
- [d3-request](https://github.com/d3/d3-request) - A convenient alternative to XMLHttpRequest
- [fetch](https://github.com/github/fetch) - A `window.fetch` javascript polyfill
- [intercooler-js](http://intercoolerjs.org/) - Making AJAX as easy as anchor tags
- [qwest](https://github.com/pyrsmk/qwest) - Ajax library with XHR2, promises and request limit
- [reqwest](https://github.com/ded/reqwest) - Browser asynchronous HTTP requests
- [superagent](https://visionmedia.github.io/superagent/) - Client-side HTTP request library

**[ back to top](#table-of-contents)**

### Events
- [bean](https://github.com/fat/bean) - Events api
- [gator.js](http://craig.is/riding/gators) - Simple event delegation
- [EventEmitter2](https://github.com/asyncly/EventEmitter2) - Events API with wildcards
- [mitt](https://github.com/developit/mitt) - Tiny functional event emitter / pubsub

**[ back to top](#table-of-contents)**

### Icons
- [elegant](http://www.elegantthemes.com/blog/resources/elegant-icon-font) - Elegant Icon font
- [evil icons](http://evil-icons.io/) - Lightweight SVG icons
- [Feather](https://feathericons.com/) - Simply beautiful open source icons
- [flaticon](http://flaticon.com/) - Tens of thousands of free monochromatic icons in SVG, font, PNG.
- [fontawesome](http://fortawesome.github.io/Font-Awesome/) - Gives you scalable vector icons that can instantly be customized
- [fontello](http://fontello.com/) - Icon fonts generator
- [foundation icon font 3](http://zurb.com/playground/foundation-icon-fonts-3) - Foundation Zurb Icon Font 3
- [ionicons](http://ionicons.com/) - The icon font for Ionic Framework
- [material-design-icons](https://github.com/google/material-design-icons) - Material Design icons by Google
- [octicons](https://octicons.github.com/) - Github icons
- [the nounproject](http://thenounproject.com/) - Icon search
- [weloveiconfonts](http://weloveiconfonts.com/) - A free & open source icon fonts hosting service
- [Icomoon](https://icomoon.io/) - Website to custom build icon fonts

**[ back to top](#table-of-contents)**

### Colors
- [bootflat color picker](http://bootflat.github.io/color-picker.html) - Color picker for flat design
- [Brand Colors](http://brandcolors.net) - Official color codes for the world's biggest brands
- [chromajs](http://old.driven-by-data.net/about/chromajs/) - Library for all kinds of color manipulations
- [chromajs color scale helper](http://gka.github.io/palettes) - Tool to help us mastering multi-hued, multi-stops color scales
- [coolors](http://coolors.co/) - Super fast color scheme generator
- [color](http://color.hailpixel.com/) - Intuitive color picker
- [colorbrewer2](http://colorbrewer2.org/) - Color advice for cartography
- [ColorHexa](http://www.colorhexa.com/) - Color encyclopedia : Information and conversion
- [colourco](http://colourco.de/) - Color scheme tool
- [colormind](http://colormind.io/) - Deep learning AI that knows color theory and creates color schemes
- [Colors](http://clrs.cc/) - Smarter Default colors on the web
- [hcl-picker](http://tristen.ca/hcl-picker/) - Colorpicker for data
- [kewler](https://github.com/adriantoine/kewler) - Functional and immutable color manipulation library
- [khroma](http://khroma.co/) - AI color tool for designers
- [polychrome](https://github.com/cdonohue/polychrome) - Color manipulation helper
- [uiGradients](http://uigradients.com/) - A handpicked collection of beautiful colour gradients for design and code
- [vibrant.js](https://github.com/jariz/vibrant.js/) - Extract prominent colors from an image

**[ back to top](#table-of-contents)**

### Databases/Storage
- [basil.js](https://github.com/Wisembly/basil.js) - Persistence layer
- [Dexie.js](http://dexie.org/) - Wrapper for IndexedDB
- [ForerunnerDB](http://www.forerunnerdb.com/) - Database with mongo-like query language and data-binding support
- [localForage](https://github.com/mozilla/localForage) - Library like a localStorage API with fallback store for browsers with no IndexedDB or WebSQL support
- [LokiJS](http://lokijs.org/) - Embeddable / in-memory database
- [lovefield](https://github.com/google/lovefield) - SQL-like, relational query engine for the browser
- [pouchdb](http://pouchdb.com/) - Created to help developers build applications that work as well offline as they do online
- [rxdb](https://github.com/pubkey/rxdb) - Reactive, serverless, client-side, offline-first database
- [store.js](https://github.com/marcuswestin/store.js/) - LocalStorage wrapper for all browsers without using cookies or 
flash. Uses localStorage, globalStorage and userData behavior
- [taffydb](http://www.taffydb.com/) - Brings database features into your JavaScript applications
- [ZangoDB](https://github.com/erikolson186/zangodb) - MongoDB-like interface for HTML5 IndexedDB

**[ back to top](#table-of-contents)**

### Validation
- [is.js](http://arasatasaygin.github.io/is.js/) - Micro check library
- [Parsley](https://github.com/guillaumepotier/Parsley.js) - Easy Form validation
- [validate.js](https://github.com/rickharrison/validate.js) - Form validation library inspired by CodeIgniter
- [validator.js](https://github.com/chriso/validator.js) - String validation and sanitization

**[ back to top](#table-of-contents)**

### Dates
- [datedropper](http://felicegattuso.com/projects/datedropper/) - JQuery plugin that provides a way to manage dates for input fields
- [dateformat](https://github.com/felixge/node-dateformat) - Library for formatting dates
- [date-fns](https://github.com/date-fns/date-fns) - Toolset for manipulating dates
- [flatpickr](https://chmln.github.io/flatpickr/) - Lightweight date time picker without dependencies 
- [instadate](https://github.com/teamweek/instadate) - A minimal date library
- [luxon](https://github.com/moment/luxon) - A library for working with dates and times
- [moment.js](http://momentjs.com/) - Parse, validate, manipulate, and display dates
- [Pikaday](http://dbushell.github.io/Pikaday/) - A lightweight Datepicker
- [sugar](http://sugarjs.com/dates) - Parse, create, manipulate, compare, format and display dates
- [tinytime](https://github.com/aweary/tinytime) - Light date and time formatter

**[ back to top](#table-of-contents)**

### Internationalization
- [l10ns](http://l10ns.org/) - Internationalization workflowand formatting
- [globalize](https://github.com/jquery/globalize) - A library for internationalization and localization that leverages the official Unicode CLDR JSON data

**[ back to top](#table-of-contents)**

### Numbers & Currencies
- [Numbro.js](http://numbrojs.com/) - Formatting and manipulating numbers in more than 30 languages
- [accounting.js](http://openexchangerates.github.io/accounting.js) - Number, money and currency formatting
- [money.js](http://openexchangerates.github.io/money.js/) - Currency conversion library
- [cleave.js](http://nosir.github.io/cleave.js/) - Format input text content when you are typing

**[ back to top](#table-of-contents)**

### Statistics & data analysis
- [datakit](https://github.com/nathanepstein/datakit) - Framework for data analysis
- [datalib](https://github.com/vega/datalib) - Data utility library
- [gauss](https://github.com/wayoutmind/gauss) - Statistics, analytics, and data library
- [jstat](https://github.com/jstat/jstat) - Javascript Statistical Library
- [science.js](https://github.com/jasondavies/science.js) - Scientific and statistical computing in JavaScript
- [simple-statistics](https://github.com/simple-statistics/simple-statistics) - simple statistics for node & browser javascript
- [statkit](https://github.com/rigtorp/statkit) - Statistics toolkit

**[ back to top](#table-of-contents)**

### Module Loaders
- [Browserify](http://browserify.org/) - Lets you require('modules') in the browser
- [RequireJS](https://github.com/jrburke/requirejs) - A file and AMD module loader
- [Rollup](https://github.com/rollup/rollup) - ES6 module bundler with tree shaking abilities
- [stealjs](http://stealjs.com/) - Dependency loader and builder
- [Systemjs](https://github.com/systemjs/systemjs) - ES6, AMD and CommonJS loader
- [webpack](http://webpack.github.io/) - CommonJs and AMD module loader

**[ back to top](#table-of-contents)**

### Lazy Loading
- [Aload](http://pazguille.github.io/aload/) - Asynchronously loads images, scripts, styles and more
- [echo](http://toddmotto.com/labs/echo/) - Standalone lazy loading image micro-library
- [Lazy Progressive Enhancement](http://tylerdeitz.co/lazy-progressive-enhancement/) - A lazy image loader designed to enforce progressive enhancement and valid HTML
- [layzr.js](http://callmecavs.github.io/layzr.js/) - Dependency-free library for lazy loading images
- [lazysizes](https://github.com/aFarkas/lazysizes) - fast and self-initializing lazyloader for images, iframes and more
- [loadXT](https://github.com/ressio/lazy-load-xt) - Lazy loading for any elements
- [Unveil](http://luis-almeida.github.io/unveil/) - Lightweight plugin to lazy load images for jQuery or Zepto.js

**[ back to top](#table-of-contents)**

### Neural Networks
- [brain](https://github.com/harthur-org/brain) - Neural networks in JavaScript
- [ConvNetJS](http://cs.stanford.edu/people/karpathy/convnetjs/) - Library for training Deep Learning models
- [deeplearn.js](https://github.com/PAIR-code/deeplearnjs) - Hardware-accelerated machine intelligence library
- [dn2a-javascript](https://github.com/dn2a/dn2a-javascript) - Digital Neural Networks Architecture
- [Mind](http://www.mindjs.net/) - Flexible neural networks
- [neurojs](https://github.com/janhuenermann/neurojs) - Deep learning and reinforcement learning library
- [synaptic.js](http://synaptic.juancazala.com/#/) - Architecture-free neural network
- [Tensor Fire](https://tenso.rs/) - Neural networks in the browser using WebGL

**[ back to top](#table-of-contents)**

### Social
- [js socials](http://js-socials.com/) - Social network sharing jQuery plugin
- [rrssb](http://kurtnoble.com/labs/rrssb/) - Ridiculously Responsive Social Sharing Buttons
- [share-button](http://sharebutton.co/) - Fast, beautiful, and painless social shares
- [sharingbuttons](http://sharingbuttons.io/) - Social media sharing buttons without JavaScript
- [socialcount](http://www.filamentgroup.com/lab/socialcount.html) - Custom sharing buttons with share count
- [Social Likes](http://sapegin.github.io/social-likes/) - Single-style sharing buttons with counters for jQuery
- [whatsapp button](http://whatsapp-sharing.com/) - Creates a whatsapp sharing button

**[ back to top](#table-of-contents)**

### Utility Libraries
- [lazy.js](http://danieltao.com/lazy.js/) - A functional utility library
- [lodash](https://lodash.com/) - Utility library delivering modularity, performance & extras.
- [moutjs](http://moutjs.com/) - Collection of modular JavaScript utilities 
- [pareto.js](https://github.com/concretesolutions/pareto.js) - Functional utility library
- [ramdajs](http://ramdajs.com/) - A practical functional library
- [underscore](http://underscorejs.org/) - Library that provides functional programming helpers

**[ back to top](#table-of-contents)**

### General
- [dat.GUI](https://github.com/dataarts/dat.gui) - Minimal interface for live control of variables in JS
- [embed.js](https://github.com/ritz078/embed.js) - Automatically embeds emojis, media, maps, tweets, code and services
- [formstone](http://formstone.it/) - Collection of handy useful scripts
- [golden-layout](https://golden-layout.com/) - A multi-screen layout manager for webapps
- [interact.js](http://interactjs.io/) - Drag and drop, resizing and multi-touch gestures with inertia and snapping
- [jwerty](http://keithamus.github.io/jwerty/) - Handling of keyboard events
- [keymaster](https://github.com/madrobby/keymaster) - Simple key listener
- [modernizr](http://modernizr.com/) - Feature Detection Library
- [tether](http://github.hubspot.com/tether/docs/welcome/) - Marrying UI Elements (dropdown, tooltips, guide, selects)
- [UpUp](https://www.talater.com/upup/) - Offline First library. Let users visit your site, even without a connection.
- [bro-fs](https://github.com/vitalets/bro-fs) - Promise-based wrapper over [HTML5 Filesystem API](https://dev.w3.org/2009/dap/file-system/file-dir-sys.html) allowing to work with sandboxed filesystem in Chrome

**[ back to top](#table-of-contents)**
