// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/certificatemanager/v1/trust_config.proto

package certificatemanagerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for the `ListTrustConfigs` method.
type ListTrustConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the TrustConfigs should be
	// listed, specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of TrustConfigs to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListTrustConfigsResponse`. Indicates
	// that this is a continuation of a prior `ListTrustConfigs` call, and that
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the TrustConfigs returned.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A list of TrustConfig field names used to specify the order of the
	// returned results. The default sorting order is ascending. To specify
	// descending order for a field, add a suffix `" desc"`.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTrustConfigsRequest) Reset() {
	*x = ListTrustConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTrustConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTrustConfigsRequest) ProtoMessage() {}

func (x *ListTrustConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTrustConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListTrustConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{0}
}

func (x *ListTrustConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTrustConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTrustConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTrustConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTrustConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListTrustConfigs` method.
type ListTrustConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of TrustConfigs for the parent resource.
	TrustConfigs []*TrustConfig `protobuf:"bytes,1,rep,name=trust_configs,json=trustConfigs,proto3" json:"trust_configs,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTrustConfigsResponse) Reset() {
	*x = ListTrustConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTrustConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTrustConfigsResponse) ProtoMessage() {}

func (x *ListTrustConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTrustConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListTrustConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{1}
}

func (x *ListTrustConfigsResponse) GetTrustConfigs() []*TrustConfig {
	if x != nil {
		return x.TrustConfigs
	}
	return nil
}

func (x *ListTrustConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTrustConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetTrustConfig` method.
type GetTrustConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the TrustConfig to describe. Must be in the format
	// `projects/*/locations/*/trustConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTrustConfigRequest) Reset() {
	*x = GetTrustConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrustConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrustConfigRequest) ProtoMessage() {}

func (x *GetTrustConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrustConfigRequest.ProtoReflect.Descriptor instead.
func (*GetTrustConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{2}
}

func (x *GetTrustConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateTrustConfig` method.
type CreateTrustConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the TrustConfig. Must be in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A user-provided name of the TrustConfig. Must match the regexp
	// `[a-z0-9-]{1,63}`.
	TrustConfigId string `protobuf:"bytes,2,opt,name=trust_config_id,json=trustConfigId,proto3" json:"trust_config_id,omitempty"`
	// Required. A definition of the TrustConfig to create.
	TrustConfig *TrustConfig `protobuf:"bytes,3,opt,name=trust_config,json=trustConfig,proto3" json:"trust_config,omitempty"`
}

func (x *CreateTrustConfigRequest) Reset() {
	*x = CreateTrustConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTrustConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTrustConfigRequest) ProtoMessage() {}

func (x *CreateTrustConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTrustConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateTrustConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{3}
}

func (x *CreateTrustConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTrustConfigRequest) GetTrustConfigId() string {
	if x != nil {
		return x.TrustConfigId
	}
	return ""
}

func (x *CreateTrustConfigRequest) GetTrustConfig() *TrustConfig {
	if x != nil {
		return x.TrustConfig
	}
	return nil
}

// Request for the `UpdateTrustConfig` method.
type UpdateTrustConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A definition of the TrustConfig to update.
	TrustConfig *TrustConfig `protobuf:"bytes,1,opt,name=trust_config,json=trustConfig,proto3" json:"trust_config,omitempty"`
	// Required. The update mask applies to the resource. For the `FieldMask`
	// definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTrustConfigRequest) Reset() {
	*x = UpdateTrustConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTrustConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTrustConfigRequest) ProtoMessage() {}

func (x *UpdateTrustConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTrustConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateTrustConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateTrustConfigRequest) GetTrustConfig() *TrustConfig {
	if x != nil {
		return x.TrustConfig
	}
	return nil
}

func (x *UpdateTrustConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `DeleteTrustConfig` method.
type DeleteTrustConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the TrustConfig to delete. Must be in the format
	// `projects/*/locations/*/trustConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current etag of the TrustConfig.
	// If an etag is provided and does not match the current etag of the resource,
	// deletion will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteTrustConfigRequest) Reset() {
	*x = DeleteTrustConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTrustConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTrustConfigRequest) ProtoMessage() {}

func (x *DeleteTrustConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTrustConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteTrustConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteTrustConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTrustConfigRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Defines a trust config.
type TrustConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the trust config. TrustConfig names must be
	// unique globally and match pattern
	// `projects/*/locations/*/trustConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation timestamp of a TrustConfig.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a TrustConfig.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of labels associated with a TrustConfig.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// One or more paragraphs of text description of a TrustConfig.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// Set of trust stores to perform validation against.
	//
	// This field is supported when TrustConfig is configured with Load Balancers,
	// currently not supported for SPIFFE certificate validation.
	//
	// Only one TrustStore specified is currently allowed.
	TrustStores []*TrustConfig_TrustStore `protobuf:"bytes,8,rep,name=trust_stores,json=trustStores,proto3" json:"trust_stores,omitempty"`
}

func (x *TrustConfig) Reset() {
	*x = TrustConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustConfig) ProtoMessage() {}

func (x *TrustConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustConfig.ProtoReflect.Descriptor instead.
func (*TrustConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{6}
}

func (x *TrustConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TrustConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TrustConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TrustConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TrustConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TrustConfig) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *TrustConfig) GetTrustStores() []*TrustConfig_TrustStore {
	if x != nil {
		return x.TrustStores
	}
	return nil
}

// Defines a trust anchor.
type TrustConfig_TrustAnchor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*TrustConfig_TrustAnchor_PemCertificate
	Kind isTrustConfig_TrustAnchor_Kind `protobuf_oneof:"kind"`
}

func (x *TrustConfig_TrustAnchor) Reset() {
	*x = TrustConfig_TrustAnchor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustConfig_TrustAnchor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustConfig_TrustAnchor) ProtoMessage() {}

func (x *TrustConfig_TrustAnchor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustConfig_TrustAnchor.ProtoReflect.Descriptor instead.
func (*TrustConfig_TrustAnchor) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{6, 0}
}

func (m *TrustConfig_TrustAnchor) GetKind() isTrustConfig_TrustAnchor_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *TrustConfig_TrustAnchor) GetPemCertificate() string {
	if x, ok := x.GetKind().(*TrustConfig_TrustAnchor_PemCertificate); ok {
		return x.PemCertificate
	}
	return ""
}

type isTrustConfig_TrustAnchor_Kind interface {
	isTrustConfig_TrustAnchor_Kind()
}

type TrustConfig_TrustAnchor_PemCertificate struct {
	// PEM root certificate of the PKI used for validation.
	//
	// Each certificate provided in PEM format may occupy up to 5kB.
	PemCertificate string `protobuf:"bytes,1,opt,name=pem_certificate,json=pemCertificate,proto3,oneof"`
}

func (*TrustConfig_TrustAnchor_PemCertificate) isTrustConfig_TrustAnchor_Kind() {}

// Defines an intermediate CA.
type TrustConfig_IntermediateCA struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*TrustConfig_IntermediateCA_PemCertificate
	Kind isTrustConfig_IntermediateCA_Kind `protobuf_oneof:"kind"`
}

func (x *TrustConfig_IntermediateCA) Reset() {
	*x = TrustConfig_IntermediateCA{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustConfig_IntermediateCA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustConfig_IntermediateCA) ProtoMessage() {}

func (x *TrustConfig_IntermediateCA) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustConfig_IntermediateCA.ProtoReflect.Descriptor instead.
func (*TrustConfig_IntermediateCA) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{6, 1}
}

func (m *TrustConfig_IntermediateCA) GetKind() isTrustConfig_IntermediateCA_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *TrustConfig_IntermediateCA) GetPemCertificate() string {
	if x, ok := x.GetKind().(*TrustConfig_IntermediateCA_PemCertificate); ok {
		return x.PemCertificate
	}
	return ""
}

type isTrustConfig_IntermediateCA_Kind interface {
	isTrustConfig_IntermediateCA_Kind()
}

type TrustConfig_IntermediateCA_PemCertificate struct {
	// PEM intermediate certificate used for building up paths
	// for validation.
	//
	// Each certificate provided in PEM format may occupy up to 5kB.
	PemCertificate string `protobuf:"bytes,1,opt,name=pem_certificate,json=pemCertificate,proto3,oneof"`
}

func (*TrustConfig_IntermediateCA_PemCertificate) isTrustConfig_IntermediateCA_Kind() {}

// Defines a trust store.
type TrustConfig_TrustStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Trust Anchors to be used while performing validation
	// against a given TrustStore.
	TrustAnchors []*TrustConfig_TrustAnchor `protobuf:"bytes,1,rep,name=trust_anchors,json=trustAnchors,proto3" json:"trust_anchors,omitempty"`
	// Set of intermediate CA certificates used for the path building
	// phase of chain validation.
	//
	// The field is currently not supported if TrustConfig is used for the
	// workload certificate feature.
	IntermediateCas []*TrustConfig_IntermediateCA `protobuf:"bytes,2,rep,name=intermediate_cas,json=intermediateCas,proto3" json:"intermediate_cas,omitempty"`
}

func (x *TrustConfig_TrustStore) Reset() {
	*x = TrustConfig_TrustStore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustConfig_TrustStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustConfig_TrustStore) ProtoMessage() {}

func (x *TrustConfig_TrustStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustConfig_TrustStore.ProtoReflect.Descriptor instead.
func (*TrustConfig_TrustStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP(), []int{6, 2}
}

func (x *TrustConfig_TrustStore) GetTrustAnchors() []*TrustConfig_TrustAnchor {
	if x != nil {
		return x.TrustAnchors
	}
	return nil
}

func (x *TrustConfig_TrustStore) GetIntermediateCas() []*TrustConfig_IntermediateCA {
	if x != nil {
		return x.IntermediateCas
	}
	return nil
}

var File_google_cloud_certificatemanager_v1_trust_config_proto protoreflect.FileDescriptor

var file_google_cloud_certificatemanager_v1_trust_config_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xba, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x62, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe3, 0x01, 0x0a, 0x18, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x74, 0x72, 0x75,
	0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x0c, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x74, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0xb5, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0c,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x72, 0x75, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x79, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x75,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x22, 0xa6, 0x07, 0x0a, 0x0b, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x5d, 0x0a, 0x0c, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x72, 0x75,
	0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0b, 0x74, 0x72, 0x75, 0x73, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x1a, 0x40, 0x0a, 0x0b, 0x54, 0x72, 0x75, 0x73, 0x74, 0x41, 0x6e, 0x63,
	0x68, 0x6f, 0x72, 0x12, 0x29, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e,
	0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x06,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x43, 0x0a, 0x0e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x41, 0x12, 0x29, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0xd9, 0x01, 0x0a, 0x0a,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x60, 0x0a, 0x0d, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x52, 0x0c,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x12, 0x69, 0x0a, 0x10,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x43, 0x41, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x75, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x42, 0x86, 0x02, 0x0a, 0x26,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x54, 0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x69, 0x66, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x25, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescOnce sync.Once
	file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescData = file_google_cloud_certificatemanager_v1_trust_config_proto_rawDesc
)

func file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescGZIP() []byte {
	file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescData)
	})
	return file_google_cloud_certificatemanager_v1_trust_config_proto_rawDescData
}

var file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_certificatemanager_v1_trust_config_proto_goTypes = []interface{}{
	(*ListTrustConfigsRequest)(nil),    // 0: google.cloud.certificatemanager.v1.ListTrustConfigsRequest
	(*ListTrustConfigsResponse)(nil),   // 1: google.cloud.certificatemanager.v1.ListTrustConfigsResponse
	(*GetTrustConfigRequest)(nil),      // 2: google.cloud.certificatemanager.v1.GetTrustConfigRequest
	(*CreateTrustConfigRequest)(nil),   // 3: google.cloud.certificatemanager.v1.CreateTrustConfigRequest
	(*UpdateTrustConfigRequest)(nil),   // 4: google.cloud.certificatemanager.v1.UpdateTrustConfigRequest
	(*DeleteTrustConfigRequest)(nil),   // 5: google.cloud.certificatemanager.v1.DeleteTrustConfigRequest
	(*TrustConfig)(nil),                // 6: google.cloud.certificatemanager.v1.TrustConfig
	(*TrustConfig_TrustAnchor)(nil),    // 7: google.cloud.certificatemanager.v1.TrustConfig.TrustAnchor
	(*TrustConfig_IntermediateCA)(nil), // 8: google.cloud.certificatemanager.v1.TrustConfig.IntermediateCA
	(*TrustConfig_TrustStore)(nil),     // 9: google.cloud.certificatemanager.v1.TrustConfig.TrustStore
	nil,                                // 10: google.cloud.certificatemanager.v1.TrustConfig.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),      // 11: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),      // 12: google.protobuf.Timestamp
}
var file_google_cloud_certificatemanager_v1_trust_config_proto_depIdxs = []int32{
	6,  // 0: google.cloud.certificatemanager.v1.ListTrustConfigsResponse.trust_configs:type_name -> google.cloud.certificatemanager.v1.TrustConfig
	6,  // 1: google.cloud.certificatemanager.v1.CreateTrustConfigRequest.trust_config:type_name -> google.cloud.certificatemanager.v1.TrustConfig
	6,  // 2: google.cloud.certificatemanager.v1.UpdateTrustConfigRequest.trust_config:type_name -> google.cloud.certificatemanager.v1.TrustConfig
	11, // 3: google.cloud.certificatemanager.v1.UpdateTrustConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 4: google.cloud.certificatemanager.v1.TrustConfig.create_time:type_name -> google.protobuf.Timestamp
	12, // 5: google.cloud.certificatemanager.v1.TrustConfig.update_time:type_name -> google.protobuf.Timestamp
	10, // 6: google.cloud.certificatemanager.v1.TrustConfig.labels:type_name -> google.cloud.certificatemanager.v1.TrustConfig.LabelsEntry
	9,  // 7: google.cloud.certificatemanager.v1.TrustConfig.trust_stores:type_name -> google.cloud.certificatemanager.v1.TrustConfig.TrustStore
	7,  // 8: google.cloud.certificatemanager.v1.TrustConfig.TrustStore.trust_anchors:type_name -> google.cloud.certificatemanager.v1.TrustConfig.TrustAnchor
	8,  // 9: google.cloud.certificatemanager.v1.TrustConfig.TrustStore.intermediate_cas:type_name -> google.cloud.certificatemanager.v1.TrustConfig.IntermediateCA
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_certificatemanager_v1_trust_config_proto_init() }
func file_google_cloud_certificatemanager_v1_trust_config_proto_init() {
	if File_google_cloud_certificatemanager_v1_trust_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTrustConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTrustConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrustConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTrustConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTrustConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTrustConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustConfig_TrustAnchor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustConfig_IntermediateCA); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustConfig_TrustStore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*TrustConfig_TrustAnchor_PemCertificate)(nil),
	}
	file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*TrustConfig_IntermediateCA_PemCertificate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_certificatemanager_v1_trust_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_certificatemanager_v1_trust_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_certificatemanager_v1_trust_config_proto_depIdxs,
		MessageInfos:      file_google_cloud_certificatemanager_v1_trust_config_proto_msgTypes,
	}.Build()
	File_google_cloud_certificatemanager_v1_trust_config_proto = out.File
	file_google_cloud_certificatemanager_v1_trust_config_proto_rawDesc = nil
	file_google_cloud_certificatemanager_v1_trust_config_proto_goTypes = nil
	file_google_cloud_certificatemanager_v1_trust_config_proto_depIdxs = nil
}
