// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package mapsplatformdatasets_test

import (
	"context"

	mapsplatformdatasets "cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha"
	mapsplatformdatasetspb "cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb"
	"google.golang.org/api/iterator"
)

func ExampleNewMapsPlatformDatasetsV1AlphaClient() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleNewMapsPlatformDatasetsV1AlphaRESTClient() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaRESTClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleMapsPlatformDatasetsV1AlphaClient_CreateDataset() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.CreateDatasetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#CreateDatasetRequest.
	}
	resp, err := c.CreateDataset(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleMapsPlatformDatasetsV1AlphaClient_DeleteDataset() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.DeleteDatasetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#DeleteDatasetRequest.
	}
	err = c.DeleteDataset(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleMapsPlatformDatasetsV1AlphaClient_DeleteDatasetVersion() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.DeleteDatasetVersionRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#DeleteDatasetVersionRequest.
	}
	err = c.DeleteDatasetVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleMapsPlatformDatasetsV1AlphaClient_GetDataset() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.GetDatasetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#GetDatasetRequest.
	}
	resp, err := c.GetDataset(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleMapsPlatformDatasetsV1AlphaClient_ListDatasetVersions() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.ListDatasetVersionsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#ListDatasetVersionsRequest.
	}
	it := c.ListDatasetVersions(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleMapsPlatformDatasetsV1AlphaClient_ListDatasets() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.ListDatasetsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#ListDatasetsRequest.
	}
	it := c.ListDatasets(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleMapsPlatformDatasetsV1AlphaClient_UpdateDatasetMetadata() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := mapsplatformdatasets.NewMapsPlatformDatasetsV1AlphaClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &mapsplatformdatasetspb.UpdateDatasetMetadataRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/maps/mapsplatformdatasets/apiv1alpha/mapsplatformdatasetspb#UpdateDatasetMetadataRequest.
	}
	resp, err := c.UpdateDatasetMetadata(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}
