# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Test custom renderers for package archives."""

from pgpy import PGPKey, PGPKeyring
from pgpy.constants import EllipticCurveOID, PubKeyAlgorithm

from debusine.test.base import TestCase
from debusine.web.archives.renderers import SigningKeysRenderer


class SigningKeysRendererTests(TestCase):
    """Test rendering OpenPGP signing keys."""

    def test_render(self) -> None:
        keys = [
            PGPKey.new(PubKeyAlgorithm.EdDSA, EllipticCurveOID.Ed25519).pubkey
            for _ in range(2)
        ]
        rendered = SigningKeysRenderer().render(
            {"signing_keys": [str(key) for key in keys]}
        )
        self.assertTrue(
            rendered.startswith("-----BEGIN PGP PUBLIC KEY BLOCK-----\n")
        )
        self.assertEqual(
            PGPKeyring(rendered).fingerprints(),
            {key.fingerprint for key in keys},
        )
