# Generated by Django 4.2.18 on 2025-02-09 22:45

import pgtrigger.compiler
import pgtrigger.migrations
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0125_add_group_ephemeral'),
    ]

    operations = [
        migrations.AddField(
            model_name='filestore',
            name='instance_wide',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='filestoreinscope',
            name='_file_store_instance_wide',
            field=models.BooleanField(
                db_column='file_store_instance_wide',
                default=True,
                editable=False,
                help_text='Synced from FileStore.instance_wide; do not update directly',
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name='filestore',
            trigger=pgtrigger.compiler.Trigger(
                name='db_filestore_sync_instance_wide',
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func='UPDATE db_filestoreinscope SET file_store_instance_wide = NEW.instance_wide WHERE db_filestoreinscope.file_store_id = NEW.id AND db_filestoreinscope.file_store_instance_wide != NEW.instance_wide; RETURN NEW;',
                    hash='7dfd74c5dbb675f55873e1fa249285a172869cf3',
                    operation='INSERT OR UPDATE',
                    pgid='pgtrigger_db_filestore_sync_instance_wide_e2fab',
                    table='db_filestore',
                    when='AFTER',
                ),
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name='filestoreinscope',
            trigger=pgtrigger.compiler.Trigger(
                name='db_filestoreinscope_sync_instance_wide',
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func='NEW.file_store_instance_wide = (SELECT db_filestore.instance_wide FROM db_filestore WHERE db_filestore.id = NEW.file_store_id); RETURN NEW;',
                    hash='04b1ed9053b9e9ea2cf78d10850742c925eeae66',
                    operation='INSERT OR UPDATE',
                    pgid='pgtrigger_db_filestoreinscope_sync_instance_wide_c82e6',
                    table='db_filestoreinscope',
                    when='BEFORE',
                ),
            ),
        ),
        migrations.AddConstraint(
            model_name='filestoreinscope',
            constraint=models.UniqueConstraint(
                condition=models.Q(('_file_store_instance_wide', False)),
                fields=('file_store',),
                name='db_filestoreinscope_unique_file_store_not_instance_wide',
            ),
        ),
    ]
