/*****************************************************************************
 * desc_32.h: ISO/IEC 13818-1 Descriptor 0x32 (J2K video descriptor)
 *****************************************************************************
 * Copyright Bridge Technologies Co AS
 *
 * Authors: Peter Krefting
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __BITSTREAM_MPEG_DESC_32_H__
#define __BITSTREAM_MPEG_DESC_32_H__

#include <bitstream/common.h>
#include <bitstream/mpeg/psi/descriptors.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*****************************************************************************
 * Descriptor 0x32 (J2K video descriptor)
 *****************************************************************************/
#define DESC32_HEADER_SIZE      (DESC_HEADER_SIZE + 24)

static inline void desc32_init(uint8_t *p_desc)
{
    desc_set_tag(p_desc, 0x32);
    desc_set_length(p_desc, DESC32_HEADER_SIZE - DESC_HEADER_SIZE);
}

static inline bool desc32_validate(const uint8_t *p_desc)
{
    return desc_get_length(p_desc) >= DESC32_HEADER_SIZE - DESC_HEADER_SIZE;
}

static inline bool desc32_get_interlaced_video(const uint8_t *p_desc)
{
    return (p_desc[25] & 0x01) == 0x01;
}

#ifdef __cplusplus
}
#endif

#endif
